/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.nbt;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.nbt.NbtAdapter;
import iskallia.vault.core.data.adapter.number.BoundedIntAdapter;
import iskallia.vault.core.net.BitBuffer;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class CollectionNbtAdapter
extends NbtAdapter<CollectionTag<?>> {
    private static NbtAdapter[] ADAPTERS = new NbtAdapter[]{Adapters.BYTE_ARRAY_NBT, Adapters.INT_ARRAY_NBT, Adapters.LONG_ARRAY_NBT, Adapters.LIST_NBT};
    private static final BoundedIntAdapter ID = new BoundedIntAdapter(0, ADAPTERS.length - 1, false);
    private static final Object2IntMap<Class<?>> TYPE_TO_ID = new Object2IntOpenHashMap();

    public CollectionNbtAdapter(boolean nullable) {
        super(nullable);
    }

    public CollectionNbtAdapter asNullable() {
        return new CollectionNbtAdapter(this.isNullable());
    }

    @Override
    protected void writeTagBits(CollectionTag<?> value, BitBuffer buffer) {
        int id = TYPE_TO_ID.getInt(value.getClass());
        ID.writeBits(id, buffer);
        ADAPTERS[id].writeBits(value, buffer);
    }

    @Override
    protected CollectionTag<?> readTagBits(BitBuffer buffer) {
        int id = (Integer)ID.readBits(buffer).orElseThrow();
        return ADAPTERS[id].readBits(buffer).orElse(null);
    }

    @Override
    protected void writeTagBytes(CollectionTag<?> value, ByteBuf buffer) {
        int id = TYPE_TO_ID.getInt(value.getClass());
        ID.writeBytes(id, buffer);
        ADAPTERS[id].writeBytes(value, buffer);
    }

    @Override
    protected CollectionTag<?> readTagBytes(ByteBuf buffer) {
        int id = (Integer)ID.readBytes(buffer).orElseThrow();
        return ADAPTERS[id].readBytes(buffer).orElse(null);
    }

    @Override
    protected void writeTagData(CollectionTag<?> value, DataOutput data) throws IOException {
        int id = TYPE_TO_ID.getInt(value.getClass());
        ID.writeData(id, data);
        ADAPTERS[id].writeData(value, data);
    }

    @Override
    protected CollectionTag<?> readTagData(DataInput data) throws IOException {
        int id = (Integer)ID.readData(data).orElseThrow();
        return ADAPTERS[id].readData(data).orElse(null);
    }

    @Override
    protected Tag writeTagNbt(CollectionTag<?> value) {
        return value;
    }

    @Override
    @Nullable
    protected CollectionTag<?> readTagNbt(Tag nbt) {
        CollectionTag tag;
        return nbt instanceof CollectionTag ? (tag = (CollectionTag)nbt) : null;
    }

    @Override
    protected JsonElement writeTagJson(CollectionTag<?> value) {
        int id = TYPE_TO_ID.getInt(value.getClass());
        return ADAPTERS[id].writeJson(value).orElse(null);
    }

    @Override
    @Nullable
    protected CollectionTag<?> readTagJson(JsonElement json) {
        JsonArray array;
        if (json instanceof JsonArray && (array = (JsonArray)json).size() > 0) {
            JsonPrimitive primitive;
            String key;
            JsonElement jsonElement = array.get(0);
            String string = key = jsonElement instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement).isString() ? primitive.getAsString() : null;
            if ("B".equals(key)) {
                return Adapters.BYTE_ARRAY_NBT.readJson(json).orElse(null);
            }
            if ("I".equals(key)) {
                return Adapters.INT_ARRAY_NBT.readJson(json).orElse(null);
            }
            if ("L".equals(key)) {
                return Adapters.LONG_ARRAY_NBT.readJson(json).orElse(null);
            }
            return Adapters.LIST_NBT.readJson(json).orElse(null);
        }
        return null;
    }
}

