/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.nbt;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.nbt.NbtAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import org.jetbrains.annotations.Nullable;

public class CompoundNbtAdapter
extends NbtAdapter<CompoundTag> {
    public CompoundNbtAdapter(boolean nullable) {
        super(nullable);
    }

    public CompoundNbtAdapter asNullable() {
        return new CompoundNbtAdapter(true);
    }

    @Override
    protected void writeTagBits(CompoundTag value, BitBuffer buffer) {
        Adapters.INT_SEGMENTED_3.writeBits(value.m_128440_(), buffer);
        for (String key : value.m_128431_()) {
            Adapters.UTF_8.writeBits(key, buffer);
            Adapters.GENERIC_NBT.writeBits(value.m_128423_(key), buffer);
        }
    }

    @Override
    protected CompoundTag readTagBits(BitBuffer buffer) {
        CompoundTag compound = new CompoundTag();
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        for (int i = 0; i < size; ++i) {
            String key = Adapters.UTF_8.readBits(buffer).orElseThrow();
            Tag tag = (Tag)Adapters.GENERIC_NBT.readBits(buffer).orElseThrow();
            compound.m_128365_(key, tag);
        }
        return compound;
    }

    @Override
    protected void writeTagBytes(CompoundTag value, ByteBuf buffer) {
        Adapters.INT_SEGMENTED_3.writeBytes(value.m_128440_(), buffer);
        for (String key : value.m_128431_()) {
            Adapters.UTF_8.writeBytes(key, buffer);
            Adapters.GENERIC_NBT.writeBytes(value.m_128423_(key), buffer);
        }
    }

    @Override
    protected CompoundTag readTagBytes(ByteBuf buffer) {
        CompoundTag compound = new CompoundTag();
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBytes(buffer).orElseThrow();
        for (int i = 0; i < size; ++i) {
            String key = Adapters.UTF_8.readBytes(buffer).orElseThrow();
            Tag tag = (Tag)Adapters.GENERIC_NBT.readBytes(buffer).orElseThrow();
            compound.m_128365_(key, tag);
        }
        return compound;
    }

    @Override
    protected void writeTagData(CompoundTag value, DataOutput data) throws IOException {
        Adapters.INT_SEGMENTED_3.writeData(value.m_128440_(), data);
        for (String key : value.m_128431_()) {
            Adapters.UTF_8.writeData(key, data);
            Adapters.GENERIC_NBT.writeData(value.m_128423_(key), data);
        }
    }

    @Override
    protected CompoundTag readTagData(DataInput data) throws IOException {
        CompoundTag compound = new CompoundTag();
        int size = (Integer)Adapters.INT_SEGMENTED_3.readData(data).orElseThrow();
        for (int i = 0; i < size; ++i) {
            String key = Adapters.UTF_8.readData(data).orElseThrow();
            Tag tag = (Tag)Adapters.GENERIC_NBT.readData(data).orElseThrow();
            compound.m_128365_(key, tag);
        }
        return compound;
    }

    @Override
    protected Tag writeTagNbt(CompoundTag value) {
        return value.m_6426_();
    }

    @Override
    @Nullable
    protected CompoundTag readTagNbt(Tag nbt) {
        CompoundTag compoundTag;
        if (nbt instanceof CompoundTag) {
            CompoundTag tag = (CompoundTag)nbt;
            compoundTag = tag.m_6426_();
        } else {
            compoundTag = null;
        }
        return compoundTag;
    }

    @Override
    protected JsonElement writeTagJson(CompoundTag value) {
        return new JsonPrimitive(value.m_7916_());
    }

    @Override
    @Nullable
    protected CompoundTag readTagJson(JsonElement json) {
        JsonPrimitive primitive;
        if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
            try {
                return TagParser.m_129359_((String)primitive.getAsString());
            }
            catch (CommandSyntaxException exception) {
                return null;
            }
        }
        if (json instanceof JsonObject) {
            JsonObject object = (JsonObject)json;
            CompoundTag nbt = new CompoundTag();
            for (String key : object.keySet()) {
                JsonElement element = object.get(key);
                Adapters.GENERIC_NBT.readJson(element).ifPresent(tag -> nbt.m_128365_(key, tag));
            }
            return nbt;
        }
        return null;
    }
}

