/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.nbt;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.nbt.NbtAdapter;
import iskallia.vault.core.data.adapter.number.BoundedByteAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.nbt.Tag;

public class GenericNbtAdapter
extends NbtAdapter<Tag> {
    protected static final BoundedByteAdapter NBT_ID = new BoundedByteAdapter(0, (byte)(Adapters.NBT.length - 1), false);

    public GenericNbtAdapter(boolean nullable) {
        super(nullable);
    }

    public GenericNbtAdapter asNullable() {
        return new GenericNbtAdapter(true);
    }

    @Override
    protected void writeTagBits(Tag value, BitBuffer buffer) {
        NBT_ID.writeBits(value.m_7060_(), buffer);
        Adapters.NBT[value.m_7060_()].writeBits(value, buffer);
    }

    @Override
    protected Tag readTagBits(BitBuffer buffer) {
        return (Tag)Adapters.NBT[(Byte)NBT_ID.readBits(buffer).orElseThrow()].readBits(buffer).orElseThrow();
    }

    @Override
    protected void writeTagBytes(Tag value, ByteBuf buffer) {
        NBT_ID.writeBytes(value.m_7060_(), buffer);
        Adapters.NBT[value.m_7060_()].writeBytes(value, buffer);
    }

    @Override
    protected Tag readTagBytes(ByteBuf buffer) {
        return (Tag)Adapters.NBT[(Byte)NBT_ID.readBytes(buffer).orElseThrow()].readBytes(buffer).orElseThrow();
    }

    @Override
    protected void writeTagData(Tag value, DataOutput data) throws IOException {
        NBT_ID.writeData(value.m_7060_(), data);
        Adapters.NBT[value.m_7060_()].writeData(value, data);
    }

    @Override
    protected Tag readTagData(DataInput data) throws IOException {
        return (Tag)Adapters.NBT[(Byte)NBT_ID.readData(data).orElseThrow()].readData(data).orElseThrow();
    }

    @Override
    @Nullable
    protected Tag writeTagNbt(Tag value) {
        return Adapters.NBT[value.m_7060_()].writeNbt(value).orElse(null);
    }

    @Override
    @Nullable
    protected Tag readTagNbt(Tag nbt) {
        return Adapters.NBT[nbt.m_7060_()].readNbt(nbt).orElse(null);
    }

    @Override
    @Nullable
    protected JsonElement writeTagJson(Tag value) {
        return Adapters.NBT[value.m_7060_()].writeJson(value).orElse(null);
    }

    @Override
    @Nullable
    protected Tag readTagJson(JsonElement json) {
        if (json instanceof JsonPrimitive) {
            JsonPrimitive value = (JsonPrimitive)json;
            if (value.isNumber()) {
                return Adapters.NUMERIC_NBT.readJson((JsonElement)value).orElse(null);
            }
            if (value.isString()) {
                return Adapters.STRING_NBT.readJson((JsonElement)value).orElse(null);
            }
            if (value.isBoolean()) {
                return Adapters.BOOLEAN.writeNbt(value.getAsBoolean()).orElse(null);
            }
        } else {
            if (json instanceof JsonObject) {
                JsonObject value = (JsonObject)json;
                return Adapters.COMPOUND_NBT.readJson((JsonElement)value).orElse(null);
            }
            if (json instanceof JsonArray) {
                JsonArray value = (JsonArray)json;
                return Adapters.COLLECTION_NBT.readJson((JsonElement)value).orElse(null);
            }
        }
        return null;
    }
}

