/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.nbt;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.nbt.GenericNbtAdapter;
import iskallia.vault.core.data.adapter.nbt.NbtAdapter;
import iskallia.vault.core.net.BitBuffer;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class ListNbtAdapter
extends NbtAdapter<ListTag> {
    protected static final String[] ID_TO_KEY = new String[]{"END", "BYTE", "SHORT", "INT", "LONG", "FLOAT", "DOUBLE", "BYTE_ARRAY", "STRING", "LIST", "COMPOUND", "INT_ARRAY", "LONG_ARRAY"};
    protected static final Object2IntMap<String> KEY_TO_ID = new Object2IntOpenHashMap();

    public ListNbtAdapter(boolean nullable) {
        super(nullable);
    }

    public ListNbtAdapter asNullable() {
        return new ListNbtAdapter(this.isNullable());
    }

    @Override
    protected void writeTagBits(ListTag value, BitBuffer buffer) {
        GenericNbtAdapter.NBT_ID.writeBits(value.m_7264_(), buffer);
        Adapters.INT_SEGMENTED_3.writeBits(value.size(), buffer);
        for (Tag element : value) {
            Adapters.NBT[value.m_7264_()].writeBits(element, buffer);
        }
    }

    @Override
    protected ListTag readTagBits(BitBuffer buffer) {
        ListTag list = new ListTag();
        byte id = (Byte)GenericNbtAdapter.NBT_ID.readBits(buffer).orElseThrow();
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        for (int i = 0; i < size; ++i) {
            list.add((Object)((Tag)Adapters.NBT[id].readBits(buffer).orElseThrow()));
        }
        return list;
    }

    @Override
    protected void writeTagBytes(ListTag value, ByteBuf buffer) {
        GenericNbtAdapter.NBT_ID.writeBytes(value.m_7264_(), buffer);
        Adapters.INT_SEGMENTED_3.writeBytes(value.size(), buffer);
        for (Tag element : value) {
            Adapters.NBT[value.m_7264_()].writeBytes(element, buffer);
        }
    }

    @Override
    protected ListTag readTagBytes(ByteBuf buffer) {
        ListTag list = new ListTag();
        byte id = (Byte)GenericNbtAdapter.NBT_ID.readBytes(buffer).orElseThrow();
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBytes(buffer).orElseThrow();
        for (int i = 0; i < size; ++i) {
            list.add((Object)((Tag)Adapters.NBT[id].readBytes(buffer).orElseThrow()));
        }
        return list;
    }

    @Override
    protected void writeTagData(ListTag value, DataOutput data) throws IOException {
        GenericNbtAdapter.NBT_ID.writeData(value.m_7264_(), data);
        Adapters.INT_SEGMENTED_3.writeData(value.size(), data);
        for (Tag element : value) {
            Adapters.NBT[value.m_7264_()].writeData(element, data);
        }
    }

    @Override
    protected ListTag readTagData(DataInput data) throws IOException {
        ListTag list = new ListTag();
        byte id = (Byte)GenericNbtAdapter.NBT_ID.readData(data).orElseThrow();
        int size = (Integer)Adapters.INT_SEGMENTED_3.readData(data).orElseThrow();
        for (int i = 0; i < size; ++i) {
            list.add((Object)((Tag)Adapters.NBT[id].readData(data).orElseThrow()));
        }
        return list;
    }

    @Override
    protected Tag writeTagNbt(ListTag value) {
        return value.m_6426_();
    }

    @Override
    @Nullable
    protected ListTag readTagNbt(Tag nbt) {
        ListTag listTag;
        if (nbt instanceof ListTag) {
            ListTag tag = (ListTag)nbt;
            listTag = tag.m_6426_();
        } else {
            listTag = null;
        }
        return listTag;
    }

    @Override
    protected JsonElement writeTagJson(ListTag value) {
        JsonArray array = new JsonArray();
        array.add((Number)KEY_TO_ID.getInt((Object)value.m_7264_()));
        for (Tag tag : value) {
            Adapters.NBT[value.m_7264_()].writeJson(tag).ifPresent(o -> array.add((JsonElement)o));
        }
        return array;
    }

    @Override
    @Nullable
    protected ListTag readTagJson(JsonElement json) {
        JsonArray array;
        if (json instanceof JsonArray && !(array = (JsonArray)json).isEmpty()) {
            int id;
            JsonPrimitive primitive;
            ListTag list = new ListTag();
            JsonElement jsonElement = array.get(0);
            if (jsonElement instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement).isString() && (id = KEY_TO_ID.getInt((Object)primitive.getAsString())) >= 0) {
                for (int i = 1; i < array.size(); ++i) {
                    Adapters.NBT[id].readJson(array.get(i)).ifPresent(tag -> list.add((Object)((Tag)tag)));
                }
            } else {
                for (int i = 0; i < array.size(); ++i) {
                    JsonElement element = array.get(i);
                    try {
                        Adapters.GENERIC_NBT.readJson(element).ifPresent(arg_0 -> list.add(arg_0));
                        continue;
                    }
                    catch (UnsupportedOperationException exception) {
                        return null;
                    }
                }
            }
            return list;
        }
        return null;
    }

    static {
        for (int i = 0; i < ID_TO_KEY.length; ++i) {
            KEY_TO_ID.put((Object)ID_TO_KEY[i], i);
        }
        KEY_TO_ID.defaultReturnValue(-1);
    }
}

