/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.number;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.number.NumberAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class BigIntegerAdapter
extends NumberAdapter<BigInteger> {
    public BigIntegerAdapter(boolean nullable) {
        super(nullable);
    }

    public BigIntegerAdapter asNullable() {
        return new BigIntegerAdapter(true);
    }

    @Override
    protected void writeNumberBits(BigInteger value, BitBuffer buffer) {
        Adapters.BYTE_ARRAY.writeBits(value.toByteArray(), buffer);
    }

    @Override
    protected BigInteger readNumberBits(BitBuffer buffer) {
        return new BigInteger(Adapters.BYTE_ARRAY.readBits(buffer).orElseThrow());
    }

    @Override
    protected void writeNumberBytes(BigInteger value, ByteBuf buffer) {
        Adapters.BYTE_ARRAY.writeBytes(value.toByteArray(), buffer);
    }

    @Override
    protected BigInteger readNumberBytes(ByteBuf buffer) {
        return new BigInteger(Adapters.BYTE_ARRAY.readBytes(buffer).orElseThrow());
    }

    @Override
    protected void writeNumberData(BigInteger value, DataOutput data) throws IOException {
        Adapters.BYTE_ARRAY.writeData(value.toByteArray(), data);
    }

    @Override
    protected BigInteger readNumberData(DataInput data) throws IOException {
        return new BigInteger(Adapters.BYTE_ARRAY.readData(data).orElseThrow());
    }

    @Override
    protected Tag writeNumberNbt(BigInteger value) {
        return BigIntegerAdapter.wrap(BigIntegerAdapter.reduce(value));
    }

    @Override
    @Nullable
    protected BigInteger readNumberNbt(Tag nbt) {
        ListTag list;
        if (nbt instanceof NumericTag) {
            NumericTag numeric = (NumericTag)nbt;
            return BigInteger.valueOf(numeric.m_7046_());
        }
        if (nbt instanceof ByteArrayTag) {
            ByteArrayTag byteArray = (ByteArrayTag)nbt;
            return new BigInteger(byteArray.m_128227_());
        }
        if (nbt instanceof ListTag && (list = (ListTag)nbt).size() == 1) {
            return this.readNumberNbt(list.get(0));
        }
        if (nbt instanceof StringTag) {
            StringTag string = (StringTag)nbt;
            return BigIntegerAdapter.parse(string.m_7916_()).map(number -> {
                BigInteger value;
                return number instanceof BigInteger ? (value = (BigInteger)number) : BigInteger.valueOf(number.longValue());
            }).orElse(null);
        }
        return null;
    }

    @Override
    protected JsonElement writeNumberJson(BigInteger value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    @Nullable
    protected BigInteger readNumberJson(JsonElement json) {
        JsonArray array;
        if (json instanceof JsonObject) {
            return null;
        }
        if (json instanceof JsonArray && (array = (JsonArray)json).size() == 1) {
            return this.readNumberJson(array.get(0));
        }
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            if (primitive.isNumber()) {
                return primitive.getAsBigInteger();
            }
            if (primitive.isString()) {
                return BigIntegerAdapter.parse(primitive.getAsString()).map(number -> {
                    BigInteger value;
                    return number instanceof BigInteger ? (value = (BigInteger)number) : BigInteger.valueOf(number.longValue());
                }).orElse(null);
            }
        }
        return null;
    }
}

