/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.number;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.item.crystal.data.adapter.ISimpleAdapter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.Tag;

public class BooleanAdapter
implements ISimpleAdapter<Boolean, Tag, JsonElement> {
    private final boolean nullable;

    public BooleanAdapter(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public BooleanAdapter asNullable() {
        return new BooleanAdapter(true);
    }

    @Override
    public final void writeBits(@Nullable Boolean value, BitBuffer buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            buffer.writeBoolean(value);
        }
    }

    @Override
    public final Optional<Boolean> readBits(BitBuffer buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(buffer.readBoolean());
    }

    @Override
    public final void writeBytes(@Nullable Boolean value, ByteBuf buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            buffer.writeBoolean(value.booleanValue());
        }
    }

    @Override
    public final Optional<Boolean> readBytes(ByteBuf buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(buffer.readBoolean());
    }

    @Override
    public void writeData(@Nullable Boolean value, DataOutput data) throws IOException {
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            data.writeBoolean(value);
        }
    }

    @Override
    public Optional<Boolean> readData(DataInput data) throws IOException {
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(data.readBoolean());
    }

    @Override
    public final Optional<Tag> writeNbt(@Nullable Boolean value) {
        return value == null ? Optional.empty() : Optional.of(ByteTag.m_128273_((boolean)value));
    }

    @Override
    public final Optional<Boolean> readNbt(@Nullable Tag nbt) {
        ByteTag tag;
        return nbt instanceof ByteTag ? Optional.of((tag = (ByteTag)nbt).m_7063_() != 0) : Optional.empty();
    }

    @Override
    public final Optional<JsonElement> writeJson(@Nullable Boolean value) {
        return value == null ? Optional.empty() : Optional.of(new JsonPrimitive(value));
    }

    @Override
    public final Optional<Boolean> readJson(@Nullable JsonElement json) {
        JsonPrimitive primitive;
        JsonArray array;
        if (json instanceof JsonArray && (array = (JsonArray)json).size() == 1) {
            return this.readJson(array.get(0));
        }
        if (json instanceof JsonPrimitive && !(primitive = (JsonPrimitive)json).isBoolean()) {
            try {
                return Optional.of(primitive.getAsBoolean());
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

