/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.number;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.number.NumberAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class ByteAdapter
extends NumberAdapter<Byte> {
    public ByteAdapter(boolean nullable) {
        super(nullable);
    }

    public ByteAdapter asNullable() {
        return new ByteAdapter(true);
    }

    @Override
    protected void writeNumberBits(Byte value, BitBuffer buffer) {
        buffer.writeByte(value);
    }

    @Override
    protected Byte readNumberBits(BitBuffer buffer) {
        return buffer.readByte();
    }

    @Override
    protected void writeNumberBytes(Byte value, ByteBuf buffer) {
        buffer.writeByte((int)value.byteValue());
    }

    @Override
    protected Byte readNumberBytes(ByteBuf buffer) {
        return buffer.readByte();
    }

    @Override
    protected void writeNumberData(Byte value, DataOutput data) throws IOException {
        data.writeByte(value.byteValue());
    }

    @Override
    protected Byte readNumberData(DataInput data) throws IOException {
        return data.readByte();
    }

    @Override
    @Nullable
    protected Tag writeNumberNbt(Byte value) {
        return ByteAdapter.wrap(ByteAdapter.reduce(value));
    }

    @Override
    @Nullable
    protected Byte readNumberNbt(Tag nbt) {
        ListTag list;
        if (nbt instanceof NumericTag) {
            NumericTag numeric = (NumericTag)nbt;
            return numeric.m_7063_();
        }
        if (nbt instanceof ListTag && (list = (ListTag)nbt).size() == 1) {
            return this.readNumberNbt(list.get(0));
        }
        if (nbt instanceof StringTag) {
            StringTag string = (StringTag)nbt;
            return ByteAdapter.parse(string.toString()).map(Number::byteValue).orElse(null);
        }
        return null;
    }

    @Override
    @Nullable
    protected JsonElement writeNumberJson(Byte value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    @Nullable
    protected Byte readNumberJson(JsonElement json) {
        JsonArray array;
        if (json instanceof JsonObject) {
            return null;
        }
        if (json instanceof JsonArray && (array = (JsonArray)json).size() == 1) {
            return this.readNumberJson(array.get(0));
        }
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            if (primitive.isNumber()) {
                return primitive.getAsByte();
            }
            if (primitive.isString()) {
                return ByteAdapter.parse(primitive.getAsString()).map(Number::byteValue).orElse(null);
            }
        }
        return null;
    }
}

