/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.number;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.number.NumberAdapter;
import iskallia.vault.core.net.BitBuffer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class DoubleAdapter
extends NumberAdapter<Double> {
    public DoubleAdapter(boolean nullable) {
        super(nullable);
    }

    public DoubleAdapter asNullable() {
        return new DoubleAdapter(true);
    }

    @Override
    protected void writeNumberBits(Double value, BitBuffer buffer) {
        buffer.writeDouble(value);
    }

    @Override
    protected Double readNumberBits(BitBuffer buffer) {
        return buffer.readDouble();
    }

    @Override
    protected void writeNumberBytes(Double value, ByteBuf buffer) {
        buffer.writeDouble(value.doubleValue());
    }

    @Override
    protected Double readNumberBytes(ByteBuf buffer) {
        return buffer.readDouble();
    }

    @Override
    protected void writeNumberData(Double value, DataOutput data) throws IOException {
        data.writeDouble(value);
    }

    @Override
    protected Double readNumberData(DataInput data) throws IOException {
        return data.readDouble();
    }

    @Override
    @Nullable
    protected Tag writeNumberNbt(Double value) {
        return DoubleAdapter.wrap(DoubleAdapter.reduce(value));
    }

    @Override
    @Nullable
    protected Double readNumberNbt(Tag nbt) {
        ListTag list;
        if (nbt instanceof NumericTag) {
            NumericTag numeric = (NumericTag)nbt;
            return numeric.m_7061_();
        }
        if (nbt instanceof ListTag && (list = (ListTag)nbt).size() == 1) {
            return this.readNumberNbt(list.get(0));
        }
        if (nbt instanceof StringTag) {
            StringTag string = (StringTag)nbt;
            return DoubleAdapter.parse(string.m_7916_()).map(Number::doubleValue).orElse(null);
        }
        return null;
    }

    @Override
    @Nullable
    protected JsonElement writeNumberJson(Double value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    @Nullable
    protected Double readNumberJson(JsonElement json) {
        JsonArray array;
        if (json instanceof JsonObject) {
            return null;
        }
        if (json instanceof JsonArray && (array = (JsonArray)json).size() == 1) {
            return this.readNumberJson(array.get(0));
        }
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            if (primitive.isNumber()) {
                return primitive.getAsDouble();
            }
            if (primitive.isString()) {
                return DoubleAdapter.parse(primitive.getAsString()).map(Number::doubleValue).orElse(null);
            }
        }
        return null;
    }
}

