/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.util;

import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.item.crystal.data.adapter.ISimpleAdapter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.LongTag;
import org.jetbrains.annotations.Nullable;

public class BlockPosAdapter
implements ISimpleAdapter<BlockPos, LongTag, JsonPrimitive> {
    private final boolean nullable;

    public BlockPosAdapter(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public BlockPosAdapter asNullable() {
        return new BlockPosAdapter(true);
    }

    @Override
    public void writeBits(@Nullable BlockPos value, BitBuffer buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            buffer.writeLong(value.m_121878_());
        }
    }

    @Override
    public Optional<BlockPos> readBits(BitBuffer buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(BlockPos.m_122022_((long)buffer.readLong()));
    }

    @Override
    public void writeBytes(@Nullable BlockPos value, ByteBuf buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            buffer.writeLong(value.m_121878_());
        }
    }

    @Override
    public Optional<BlockPos> readBytes(ByteBuf buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(BlockPos.m_122022_((long)buffer.readLong()));
    }

    @Override
    public void writeData(@Nullable BlockPos value, DataOutput data) throws IOException {
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            data.writeLong(value.m_121878_());
        }
    }

    @Override
    public Optional<BlockPos> readData(DataInput data) throws IOException {
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(BlockPos.m_122022_((long)data.readLong()));
    }

    @Override
    public Optional<LongTag> writeNbt(@Nullable BlockPos value) {
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(LongTag.m_128882_((long)value.m_121878_()));
    }

    @Override
    public Optional<BlockPos> readNbt(@Nullable LongTag nbt) {
        return nbt != null ? Optional.of(BlockPos.m_122022_((long)nbt.m_7046_())) : Optional.empty();
    }

    @Override
    public Optional<JsonPrimitive> writeJson(@Nullable BlockPos value) {
        return value == null ? Optional.empty() : Optional.of(new JsonPrimitive((Number)value.m_121878_()));
    }

    @Override
    public Optional<BlockPos> readJson(@Nullable JsonPrimitive json) {
        return json != null && json.isNumber() ? Optional.of(BlockPos.m_122022_((long)json.getAsLong())) : Optional.empty();
    }
}

