/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.util.WeightedTree;
import iskallia.vault.item.crystal.data.adapter.IAdapter;
import iskallia.vault.item.crystal.data.adapter.ISimpleAdapter;
import java.util.HashSet;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public abstract class WeightedTreeAdapter<T, W extends WeightedTree<T>>
implements ISimpleAdapter<W, ListTag, JsonArray> {
    public abstract W create();

    public abstract String getName(T var1);

    public abstract IAdapter getAdapter(String var1);

    @Override
    public void writeBits(@Nullable W value, BitBuffer buffer) {
        if (value == null) {
            buffer.writeBoolean(false);
            return;
        }
        buffer.writeBoolean(true);
        Adapters.INT_SEGMENTED_7.writeBits(((WeightedTree)value).getChildren().size(), buffer);
        ((WeightedTree)value).getChildren().forEach((branch, weight) -> {
            buffer.writeBoolean(branch instanceof WeightedTree);
            buffer.writeDouble((double)weight);
            if (branch instanceof WeightedTree) {
                this.writeBits((W)((WeightedTree)branch), buffer);
            } else {
                String name = this.getName(branch);
                buffer.writeString(name);
                this.getAdapter(name).writeBits(branch, buffer, null);
            }
        });
    }

    @Override
    public Optional<W> readBits(BitBuffer buffer) {
        if (!buffer.readBoolean()) {
            return Optional.empty();
        }
        int groupSize = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        Object tree = this.create();
        for (int i = 0; i < groupSize; ++i) {
            boolean isTree = buffer.readBoolean();
            double weight = buffer.readDouble();
            if (isTree) {
                this.readBits(buffer).ifPresent(w -> tree.addTree(w, weight));
                continue;
            }
            String name = buffer.readString();
            IAdapter adapter = this.getAdapter(name);
            if (adapter == null) continue;
            adapter.readBits(buffer, null).ifPresent(o -> tree.addLeaf(o, weight));
        }
        return Optional.of(tree);
    }

    @Override
    public Optional<ListTag> writeNbt(@Nullable W value) {
        if (value == null) {
            return Optional.empty();
        }
        ListTag list = new ListTag();
        ((WeightedTree)value).getChildren().forEach((branch, weight) -> {
            CompoundTag compound = new CompoundTag();
            compound.m_128347_("weight", weight.doubleValue());
            if (branch instanceof WeightedTree) {
                this.writeNbt((W)((WeightedTree)branch)).ifPresent(element -> compound.m_128365_("pool", (Tag)element));
            } else {
                String name = this.getName(branch);
                this.getAdapter(name).writeNbt(branch, null).ifPresent(element -> compound.m_128365_(name, (Tag)element));
            }
            list.add((Object)compound);
        });
        return Optional.of(list);
    }

    @Override
    public Optional<W> readNbt(@Nullable ListTag nbt) {
        if (nbt == null) {
            return Optional.empty();
        }
        Object tree = this.create();
        for (int i = 0; i < nbt.size(); ++i) {
            CompoundTag element = nbt.m_128728_(i);
            double weight = element.m_128459_("weight");
            HashSet keys = new HashSet(element.m_128431_());
            keys.remove("weight");
            String name = (String)keys.iterator().next();
            if (name.equals("pool")) {
                this.readNbt(element.m_128437_(name, 10)).ifPresent(w -> tree.addTree(w, weight));
                continue;
            }
            IAdapter adapter = this.getAdapter(name);
            if (adapter == null) continue;
            adapter.readNbt(element.m_128423_(name), null).ifPresent(o -> tree.addLeaf(o, weight));
        }
        return Optional.of(tree);
    }

    @Override
    public Optional<JsonArray> writeJson(@Nullable W value) {
        if (value == null) {
            return Optional.empty();
        }
        JsonArray array = new JsonArray();
        ((WeightedTree)value).getChildren().forEach((branch, weight) -> {
            JsonObject object = new JsonObject();
            object.addProperty("weight", (Number)weight);
            if (branch instanceof WeightedTree) {
                this.writeJson((W)((WeightedTree)branch)).ifPresent(element -> object.add("pool", (JsonElement)element));
            } else {
                String name = this.getName(branch);
                this.getAdapter(name).writeJson(branch, null).ifPresent(element -> object.add(name, (JsonElement)element));
            }
            array.add((JsonElement)object);
        });
        return Optional.of(array);
    }

    @Override
    public Optional<W> readJson(@Nullable JsonArray json) {
        if (json == null) {
            return Optional.empty();
        }
        Object tree = this.create();
        for (int i = 0; i < json.size(); ++i) {
            JsonObject element = json.get(i).getAsJsonObject();
            double weight = element.get("weight").getAsDouble();
            HashSet keys = new HashSet(element.keySet());
            keys.remove("weight");
            String name = (String)keys.iterator().next();
            if (name.equals("pool")) {
                this.readJson(element.get(name).getAsJsonArray()).ifPresent(w -> tree.addTree(w, weight));
                continue;
            }
            IAdapter adapter = this.getAdapter(name);
            if (adapter == null) continue;
            adapter.readJson(element.get(name), null).ifPresent(o -> tree.addLeaf(o, weight));
        }
        return Optional.of(tree);
    }
}

