/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.data.adapter.vault;

import iskallia.vault.core.data.sync.context.SyncContext;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.item.crystal.data.adapter.IBitAdapter;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class DirectAdapter<T>
implements IBitAdapter<T, SyncContext> {
    private final Writer<T> writer;
    private final Reader<T> reader;

    public DirectAdapter(Writer<T> writer, Reader<T> reader) {
        this.writer = writer;
        this.reader = reader;
    }

    @Override
    public void writeBits(@Nullable T value, BitBuffer buffer, SyncContext context) {
        this.writer.writeBits(value, buffer, context);
    }

    @Override
    public Optional<T> readBits(BitBuffer buffer, SyncContext context) {
        return this.reader.readBits(buffer, context);
    }

    @FunctionalInterface
    public static interface Writer<T> {
        public void writeBits(@Nullable T var1, BitBuffer var2, SyncContext var3);
    }

    @FunctionalInterface
    public static interface Reader<T> {
        public Optional<T> readBits(BitBuffer var1, SyncContext var2);
    }
}

