/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.event.common;

import iskallia.vault.core.event.Event;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockSetEvent
extends Event<BlockSetEvent, Data> {
    public BlockSetEvent() {
    }

    protected BlockSetEvent(BlockSetEvent parent) {
        super(parent);
    }

    @Override
    public BlockSetEvent createChild() {
        return new BlockSetEvent(this);
    }

    public Data invoke(LevelWriter world, BlockPos pos, BlockState state, int flags, int recursionLeft, Type type) {
        return this.invoke(new Data(world, pos, state, flags, recursionLeft, type));
    }

    public BlockSetEvent of(Block block) {
        return (BlockSetEvent)this.filter(data -> data.getState().m_60734_() == block);
    }

    public BlockSetEvent of(BlockState state) {
        return (BlockSetEvent)this.filter(data -> data.getState() == state);
    }

    public BlockSetEvent in(LevelWriter world) {
        return (BlockSetEvent)this.filter(data -> {
            WorldGenRegion genRegion;
            LevelWriter patt1276$temp;
            return data.getWorld() == world || (patt1276$temp = data.getWorld()) instanceof WorldGenRegion && (genRegion = (WorldGenRegion)patt1276$temp).m_6018_() == world;
        });
    }

    public BlockSetEvent inWorld() {
        return (BlockSetEvent)this.filter(data -> data.getWorld() instanceof Level);
    }

    public BlockSetEvent inGenRegion() {
        return (BlockSetEvent)this.filter(data -> data.getWorld() instanceof WorldGenRegion);
    }

    public BlockSetEvent at(Type type) {
        return (BlockSetEvent)this.filter(data -> data.getType() == type);
    }

    public static class Data {
        private final LevelWriter world;
        private final BlockPos pos;
        private BlockState state;
        private int flags;
        private final int recursionLeft;
        private final Type type;

        public Data(LevelWriter world, BlockPos pos, BlockState state, int flags, int recursionLeft, Type type) {
            this.world = world;
            this.pos = pos;
            this.state = state;
            this.flags = flags;
            this.recursionLeft = recursionLeft;
            this.type = type;
        }

        public LevelWriter getWorld() {
            return this.world;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public BlockState getState() {
            return this.state;
        }

        public int getFlags() {
            return this.flags;
        }

        public int getRecursionLeft() {
            return this.recursionLeft;
        }

        public Type getType() {
            return this.type;
        }

        public void setState(BlockState state) {
            this.state = state;
        }

        public void setFlags(int flags) {
            this.flags = flags;
        }
    }

    public static enum Type {
        HEAD,
        RETURN;

    }
}

