/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.event.common;

import iskallia.vault.core.event.Event;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.GenerationStep;

public class CarversGenerationEvent
extends Event<CarversGenerationEvent, Data> {
    public CarversGenerationEvent() {
    }

    protected CarversGenerationEvent(CarversGenerationEvent parent) {
        super(parent);
    }

    @Override
    public CarversGenerationEvent createChild() {
        return new CarversGenerationEvent(this);
    }

    public Data invoke(ChunkGenerator generator, WorldGenRegion genRegion, long seed, BiomeManager biomeManager, StructureFeatureManager structureFeatureManager, ProtoChunk chunk, GenerationStep.Carving step) {
        return this.invoke(new Data(generator, genRegion, seed, biomeManager, structureFeatureManager, chunk, step));
    }

    public CarversGenerationEvent in(ServerLevel world) {
        return (CarversGenerationEvent)this.filter(data -> data.getGenRegion().m_6018_() == world);
    }

    public static class Data {
        private final ChunkGenerator generator;
        private final WorldGenRegion genRegion;
        private final long seed;
        private final BiomeManager biomeManager;
        private final StructureFeatureManager structureFeatureManager;
        private final ProtoChunk chunk;
        private final GenerationStep.Carving step;

        public Data(ChunkGenerator generator, WorldGenRegion genRegion, long seed, BiomeManager biomeManager, StructureFeatureManager structureFeatureManager, ProtoChunk chunk, GenerationStep.Carving step) {
            this.generator = generator;
            this.genRegion = genRegion;
            this.seed = seed;
            this.biomeManager = biomeManager;
            this.structureFeatureManager = structureFeatureManager;
            this.chunk = chunk;
            this.step = step;
        }

        public ChunkGenerator getGenerator() {
            return this.generator;
        }

        public WorldGenRegion getGenRegion() {
            return this.genRegion;
        }

        public long getSeed() {
            return this.seed;
        }

        public BiomeManager getBiomeManager() {
            return this.biomeManager;
        }

        public StructureFeatureManager getStructureFeatureManager() {
            return this.structureFeatureManager;
        }

        public ProtoChunk getChunk() {
            return this.chunk;
        }

        public GenerationStep.Carving getStep() {
            return this.step;
        }
    }
}

