/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault;

import iskallia.vault.block.VaultChestBlock;
import iskallia.vault.config.ShopPedestalConfig;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.ChestGenerationEvent;
import iskallia.vault.core.event.common.LootableBlockGenerationEvent;
import iskallia.vault.core.event.common.ShopPedestalGenerationEvent;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.LootLogic;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.core.vault.stat.ChestStat;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.TrappedMobChestParticlesMessage;
import iskallia.vault.util.calc.TrapDisarmChanceHelper;
import iskallia.vault.world.vault.chest.MobTrapEffect;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.network.PacketDistributor;

public class ClassicLootLogic
extends LootLogic {
    public static final SupplierKey<LootLogic> KEY = (SupplierKey)SupplierKey.of("classic", LootLogic.class).with(Version.v1_0, (LootLogic)((Object)((Supplier<LootLogic>)ClassicLootLogic::new)));
    public static final FieldRegistry FIELDS = LootLogic.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<Void> ADD_CATALYST_FRAGMENTS = (FieldKey)FieldKey.of("add_catalyst_fragments", Void.class).with(Version.v1_0, Adapters.ofVoid(), DISK.all()).register(FIELDS);
    public static final FieldKey<Void> ADD_RUNES = (FieldKey)FieldKey.of("add_runes", Void.class).with(Version.v1_11, Adapters.ofVoid(), DISK.all()).register(FIELDS);

    @Override
    public SupplierKey<LootLogic> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    protected void onChestPreGenerate(VirtualWorld world, Vault vault, ChestGenerationEvent.Data data) {
        if (this.applyTrap(world, vault, data)) {
            data.setLootTable(null);
            world.m_7731_(data.getPos(), Blocks.f_50016_.m_49966_(), 3);
        }
    }

    @Override
    protected void onChestPostGenerate(VirtualWorld world, Vault vault, ChestGenerationEvent.Data data) {
        this.generateCatalystFragments(data, vault);
        this.generateRunes(data, vault);
        this.initializeLoot(vault, data.getLoot(), data.getPos(), data.getRandom());
    }

    @Override
    protected void onBlockPreGenerate(VirtualWorld world, Vault vault, LootableBlockGenerationEvent.Data data) {
    }

    @Override
    protected void onBlockPostGenerate(VirtualWorld world, Vault vault, LootableBlockGenerationEvent.Data data) {
        this.initializeLoot(vault, data.getLoot(), data.getPos(), data.getRandom());
    }

    @Override
    protected void onShopPedestalGenerate(VirtualWorld world, Vault vault, ShopPedestalGenerationEvent.Data data) {
        int level = vault.getOptional(Vault.LEVEL).map(VaultLevel::get).orElse(0);
        ShopPedestalConfig.ShopOffer offer = ModConfigs.SHOP_PEDESTAL.getForLevel(level, data.getRandom());
        if (offer != null && !offer.isEmpty()) {
            ItemStack stack = this.initializeLoot(vault, offer.offer().m_41777_(), data.getPos(), data.getRandom());
            data.getTileEntity().setOffer(stack, OverSizedItemStack.of(offer.currency().overSizedStack()));
        }
        data.getTileEntity().setInitialized(true);
        data.getTileEntity().m_6596_();
        world.m_7260_(data.getPos(), data.getState(), data.getState(), 3);
    }

    protected boolean applyTrap(VirtualWorld world, Vault vault, ChestGenerationEvent.Data data) {
        boolean canBeTrapped;
        boolean bl = canBeTrapped = data.getState().m_60734_() == ModBlocks.WOODEN_CHEST || data.getState().m_60734_() == ModBlocks.GILDED_CHEST || data.getState().m_60734_() == ModBlocks.LIVING_CHEST || data.getState().m_60734_() == ModBlocks.ORNATE_CHEST || data.getState().m_60734_() == ModBlocks.HARDENED_CHEST || data.getState().m_60734_() == ModBlocks.FLESH_CHEST || data.getState().m_60734_() == ModBlocks.ENIGMA_CHEST || data.getState().m_60734_() == ModBlocks.GILDED_STRONGBOX || data.getState().m_60734_() == ModBlocks.ORNATE_STRONGBOX || data.getState().m_60734_() == ModBlocks.LIVING_STRONGBOX;
        if (!canBeTrapped) {
            return false;
        }
        WeightedList<String> pool = ModConfigs.VAULT_CHEST.getEffectPool(vault.get(Vault.LEVEL).get());
        if (pool == null) {
            return false;
        }
        double trapChance = ModConfigs.VAULT_CHEST.getTrapProbability(vault.get(Vault.LEVEL).get());
        trapChance = CommonEvents.CHEST_TRAP_GENERATION.invoke(data.getPlayer(), trapChance, pool).getProbability();
        float disarmChance = TrapDisarmChanceHelper.getTrapDisarmChance((LivingEntity)data.getPlayer());
        double effectiveTrapChance = trapChance * (double)(1.0f - disarmChance);
        double random = data.getRandom().nextDouble();
        if (trapChance <= 0.0 || random > effectiveTrapChance) {
            if (effectiveTrapChance < trapChance && random <= trapChance) {
                world.m_5594_(null, data.getPos(), ModSounds.DISARM_TRAP, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return false;
        }
        pool.getRandom(data.getRandom()).map(ModConfigs.VAULT_CHEST::getEffectByName).ifPresent(effect -> {
            if (effect instanceof MobTrapEffect) {
                world.m_5594_(null, data.getPos(), ModSounds.MOB_TRAP, SoundSource.BLOCKS, 1.0f, 1.0f);
                ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new TrappedMobChestParticlesMessage(data.getPos()));
            }
            effect.apply(world, vault, data.getPlayer());
        });
        vault.getOptional(Vault.STATS).map(c -> c.get(data.getPlayer().m_142081_())).ifPresent(stats -> stats.get(StatCollector.CHESTS).add(ChestStat.ofTrapped(((VaultChestBlock)data.getState().m_60734_()).getType())));
        return true;
    }

    protected void generateCatalystFragments(ChestGenerationEvent.Data data, Vault vault) {
        if (!this.has(ADD_CATALYST_FRAGMENTS)) {
            return;
        }
        if (vault.has(Vault.LEVEL) && vault.get(Vault.LEVEL).get() < ModConfigs.VAULT_CHEST_META.getCatalystMinLevel()) {
            return;
        }
        double probability = ModConfigs.VAULT_CHEST_META.getCatalystChance(data.getState().m_60734_(), data.getRarity());
        probability = CommonEvents.CHEST_CATALYST_GENERATION.invoke(data.getPlayer(), probability).getProbability();
        if ((double)data.getRandom().nextFloat() < probability) {
            data.getLoot().add(new ItemStack((ItemLike)ModItems.VAULT_CATALYST_FRAGMENT));
        }
    }

    protected void generateRunes(ChestGenerationEvent.Data data, Vault vault) {
        if (!this.has(ADD_RUNES)) {
            return;
        }
        double probability = ModConfigs.VAULT_CHEST_META.getRuneChance(data.getState().m_60734_(), data.getRarity());
        if ((double)data.getRandom().nextFloat() < probability) {
            data.getLoot().add(new ItemStack((ItemLike)ModItems.RUNE));
        }
    }
}

