/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.MobLogic;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.entity.EntityScaler;
import iskallia.vault.entity.Targeting;
import iskallia.vault.entity.entity.EffectCloudEntity;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.gear.attribute.custom.EffectCloudAttribute;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModParticles;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.calc.SoulChanceHelper;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;

public class ClassicMobLogic
extends MobLogic {
    public static final String SOUL_SHARDS = "soul_shards";
    public static final SupplierKey<MobLogic> KEY = (SupplierKey)SupplierKey.of("classic", MobLogic.class).with(Version.v1_0, (MobLogic)((Object)((Supplier<MobLogic>)ClassicMobLogic::new)));
    public static final FieldRegistry FIELDS = MobLogic.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<Void> BLOCK_SPAWNS = (FieldKey)FieldKey.of("block_spawns", Void.class).with(Version.v1_19, Adapters.ofVoid(), DISK.all()).register(FIELDS);

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public SupplierKey<MobLogic> getKey() {
        return KEY;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.ENTITY_CREATION.register(this, event -> {
            if (event.getEntity().f_19853_ != world) {
                return;
            }
            if (!(event.getEntity() instanceof LivingEntity)) {
                return;
            }
            if (this.has(BLOCK_SPAWNS)) {
                event.getEntity().m_142687_(Entity.RemovalReason.DISCARDED);
            }
        });
        CommonEvents.ENTITY_CHECK_SPAWN.register(this, event -> {
            if (event.getEntity().f_19853_ != world) {
                return;
            }
            if (!event.isSpawner()) {
                event.setResult(Event.Result.DENY);
            }
        });
        CommonEvents.ENTITY_TICK.register(this, event -> {
            if (event.getEntity().f_19853_ != world) {
                return;
            }
            EntityScaler.scale(vault, event.getEntityLiving());
            LivingEntity patt3845$temp = event.getEntityLiving();
            if (patt3845$temp instanceof Mob) {
                Mob mob = (Mob)patt3845$temp;
                mob.m_21553_(false);
                if (!mob.m_21023_(ModEffects.TAUNT_CHARM) && mob.m_21187_().nextInt(5) == 0) {
                    Player nearestPlayer = world.m_5788_(event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), 48.0, target -> Targeting.getTargetingResult((LivingEntity)mob, target) != Targeting.TargetingResult.IGNORE);
                    mob.m_6710_((LivingEntity)nearestPlayer);
                    mob.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)nearestPlayer);
                    mob.m_6274_().m_21879_(MemoryModuleType.f_26326_, (Object)world.m_46467_());
                    mob.m_6274_().m_21879_(MemoryModuleType.f_148206_, (Object)nearestPlayer);
                    mob.m_6274_().m_21879_(MemoryModuleType.f_26335_, (Object)true);
                    mob.m_6274_().m_21879_(MemoryModuleType.f_148205_, (Object)new NearestVisibleLivingEntities((LivingEntity)mob, new ArrayList()){

                        public boolean m_186107_(LivingEntity p_186108_) {
                            return true;
                        }

                        public boolean m_186130_(Predicate<LivingEntity> p_186131_) {
                            return true;
                        }
                    });
                }
            }
        });
        CommonEvents.ENTITY_READ.register(this, data -> {
            int usesLeft;
            if (data.getEntity().f_19853_ != world) {
                return;
            }
            if (data.getNbt() == null || !data.getNbt().m_128425_("Spawner", 10)) {
                return;
            }
            CompoundTag manager = data.getNbt().m_128469_("Spawner").m_128469_("Manager");
            int counter = manager.m_128451_("WaveCounter");
            int n = usesLeft = manager.m_128441_("UsesLeft") ? manager.m_128451_("UsesLeft") : -1;
            if (counter > 0 && usesLeft < 0) {
                return;
            }
            data.getEntity().m_19880_().add(SOUL_SHARDS);
        }, 100);
        CommonEvents.ENTITY_TICK.register(this, event -> {
            if (event.getEntity().f_19853_ != world) {
                return;
            }
            if (!event.getEntity().m_19880_().contains(SOUL_SHARDS)) {
                return;
            }
            Entity entity = event.getEntity();
            if (entity.m_183503_().m_5822_().nextInt(4) > 0) {
                return;
            }
            Vec3 at = MiscUtils.getRandomOffset(entity.m_142469_().m_82400_((double)0.2f), entity.m_183503_().m_5822_());
            world.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.PURPLE_FLAME.get()), at.f_82479_, at.f_82480_, at.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        });
        CommonEvents.ENTITY_DROPS.register((Object)this, EventPriority.HIGHEST, event -> {
            if (event.getEntity().f_19853_ != world) {
                return;
            }
            if (event.getEntity() instanceof Player) {
                return;
            }
            event.getDrops().clear();
            Entity killed = event.getEntity();
            Entity killer = event.getSource().m_7639_();
            if (!killed.m_19880_().contains(SOUL_SHARDS)) {
                return;
            }
            if (killer instanceof EternalEntity) {
                EternalEntity eternal = (EternalEntity)killer;
                killer = eternal.getOwner().right().orElse(null);
            }
            if (!(killer instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)killer;
            float chanceMultiplier = SoulChanceHelper.getSoulChance((LivingEntity)player);
            chanceMultiplier = CommonEvents.SOUL_SHARD_CHANCE.invoke(player, chanceMultiplier).getChance();
            int shardCount = ModConfigs.SOUL_SHARD.getRandomShards(killed, 1.0f + chanceMultiplier);
            if (shardCount <= 0) {
                return;
            }
            ItemStack shards = new ItemStack((ItemLike)ModItems.SOUL_SHARD, shardCount);
            ItemEntity item = new ItemEntity((Level)world, killed.m_20185_(), killed.m_20186_(), killed.m_20189_(), shards);
            item.m_32060_();
            event.getDrops().add(item);
        });
        CommonEvents.ENTITY_DEATH.register(this, event -> {
            Entity entity = event.getEntity();
            if (entity.f_19853_ != world) {
                return;
            }
            int level = vault.getOptional(Vault.LEVEL).map(VaultLevel::get).orElse(0);
            ModConfigs.VAULT_ENTITIES.getDeathEffects(level, entity).forEach(raw -> {
                EffectCloudAttribute.EffectCloud config = EffectCloudAttribute.EffectCloud.fromConfig(raw);
                if (world.m_5822_().nextFloat() >= config.getTriggerChance()) {
                    return;
                }
                EffectCloudEntity cloud = new EffectCloudEntity(entity.m_183503_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                config.apply(cloud);
                entity.m_183503_().m_7967_((Entity)cloud);
            });
        });
        CommonEvents.ENTITY_JOIN.register(this, event -> {
            Entity patt8700$temp;
            if (event.getWorld() != world) {
                return;
            }
            if (event.loadedFromDisk() || !((patt8700$temp = event.getEntity()) instanceof ThrownPotion)) {
                return;
            }
            ThrownPotion potion = (ThrownPotion)patt8700$temp;
            Entity thrower = potion.m_37282_();
            int level = vault.getOptional(Vault.LEVEL).map(VaultLevel::get).orElse(0);
            ItemStack thrown = potion.m_7846_();
            PotionUtils.m_43549_((ItemStack)thrown, (Potion)Potions.f_43599_);
            PotionUtils.m_43552_((ItemStack)thrown, ModConfigs.VAULT_ENTITIES.getThrowEffects(level, thrower));
            potion.m_37446_(thrown);
        });
        CommonEvents.EFFECT_CHECK.register(this, event -> {
            if (event.getEntity().f_19853_ != world) {
                return;
            }
            if (event.getPotionEffect().m_19544_() != MobEffects.f_19614_) {
                return;
            }
            if (event.getEntityLiving().m_6336_() == MobType.f_21641_ || event.getEntityLiving() instanceof Spider) {
                event.setResult(Event.Result.ALLOW);
            }
        });
        CommonEvents.PLAYER_EQUIPMENT_SWAP.register(this, event -> {
            UUID toId;
            UUID fromId;
            Item patt9843$temp;
            if (event.player().f_19853_ != world) {
                return;
            }
            Player patt9696$temp = event.player();
            if (!(patt9696$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sPlayer = (ServerPlayer)patt9696$temp;
            ItemStack equipped = event.to();
            if (equipped.m_41619_() || !((patt9843$temp = equipped.m_41720_()) instanceof VaultGearItem)) {
                return;
            }
            VaultGearItem gearItem = (VaultGearItem)patt9843$temp;
            ItemStack from = event.from();
            if (!from.m_41619_() && from.m_41720_() instanceof VaultGearItem && (fromId = VaultGearData.readUUID(from).orElse(Util.f_137441_)).equals(toId = VaultGearData.readUUID(equipped).orElse(Util.f_137441_))) {
                return;
            }
            if (!gearItem.shouldCauseEquipmentCooldown(sPlayer, equipped, event.slot())) {
                return;
            }
            int cooldownTicks = ModConfigs.VAULT_GEAR_COMMON.getOffHandSwapCooldown();
            ModConfigs.VAULT_GEAR_COMMON.getOffHandSwapItems().forEach(item -> sPlayer.m_36335_().m_41524_(item, cooldownTicks));
        });
        CommonEvents.ZOMBIE_REINFORCEMENT.register(this, event -> {
            if (event.getEntity().f_19853_ != world) {
                return;
            }
            event.setResult(Event.Result.DENY);
        });
    }
}

