/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault;

import iskallia.vault.VaultMod;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.ClientEvents;
import iskallia.vault.core.vault.EntityState;
import iskallia.vault.core.vault.PortalData;
import iskallia.vault.core.vault.PortalLogic;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ClassicPortalLogic
extends PortalLogic {
    public static final SupplierKey<PortalLogic> KEY = (SupplierKey)SupplierKey.of("classic", PortalLogic.class).with(Version.v1_0, (PortalLogic)((Object)((Supplier<PortalLogic>)ClassicPortalLogic::new)));
    public static final ResourceLocation ENTRANCE = VaultMod.id("entrance");
    public static final ResourceLocation EXIT = VaultMod.id("exit");
    public static final FieldRegistry FIELDS = PortalLogic.FIELDS.merge(new FieldRegistry());

    @Override
    public SupplierKey<PortalLogic> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient(Vault vault) {
        ClientEvents.COMPASS_PROPERTY.register(vault, data -> this.getPlayerStartPos(vault).ifPresent(data::setTarget));
    }

    public Optional<BlockPos> getStart() {
        return this.getPortals(ENTRANCE).findAny().map(portalData -> {
            BlockPos min = portalData.get(PortalData.MIN);
            BlockPos max = portalData.get(PortalData.MAX);
            return new BlockPos((min.m_123341_() + max.m_123341_()) / 2, min.m_123342_(), (min.m_123343_() + max.m_123343_()) / 2);
        });
    }

    public Optional<EntityState> getPlayerStart(Level world, Vault vault) {
        return this.getPlayerStartPos(vault).map(pos -> {
            Direction facing = vault.get(Vault.WORLD).get(WorldManager.FACING);
            return (EntityState)((EntityState)((EntityState)((EntityState)((EntityState)((EntityState)new EntityState().set(EntityState.POS_X, (double)pos.m_123341_() + 0.5)).set(EntityState.POS_Y, Double.valueOf(pos.m_123342_()))).set(EntityState.POS_Z, (double)pos.m_123343_() + 0.5)).set(EntityState.PITCH, Float.valueOf(0.0f))).set(EntityState.YAW, Float.valueOf(facing.m_122435_()))).set(EntityState.WORLD, world.m_46472_());
        });
    }

    public Optional<BlockPos> getPlayerStartPos(Vault vault) {
        return this.getPortals(ENTRANCE).findAny().map(portalData -> {
            BlockPos min = portalData.get(PortalData.MIN);
            BlockPos max = portalData.get(PortalData.MAX);
            BlockPos pos = new BlockPos((min.m_123341_() + max.m_123341_()) / 2, min.m_123342_(), (min.m_123343_() + max.m_123343_()) / 2);
            Direction facing = vault.get(Vault.WORLD).get(WorldManager.FACING);
            return pos.m_5484_(facing, 5);
        });
    }
}

