/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.LootTableKey;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.world.loot.generator.LootTableGenerator;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.gear.DataInitializationItem;
import iskallia.vault.item.gear.DataTransferItem;
import iskallia.vault.item.gear.VaultLevelItem;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CrateLootGenerator {
    @Nullable
    private final LootTableKey lootTable;
    private final float itemQuantity;
    private final boolean addArtifact;
    private final float artifactChance;

    public CrateLootGenerator(@Nullable LootTableKey lootTable, float itemQuantity, boolean addArtifact, float artifactChance) {
        this.lootTable = lootTable;
        this.itemQuantity = itemQuantity;
        this.addArtifact = addArtifact;
        this.artifactChance = artifactChance;
    }

    public NonNullList<ItemStack> generate(Vault vault, Listener listener, RandomSource random) {
        NonNullList<ItemStack> loot = this.createLoot(vault, listener, random);
        for (int i = 0; i < loot.size(); ++i) {
            ItemStack stack = (ItemStack)loot.get(i);
            VaultLevelItem.doInitializeVaultLoot(stack, vault, null);
            stack = DataTransferItem.doConvertStack(stack);
            DataInitializationItem.doInitialize(stack);
            loot.set(i, (Object)stack);
        }
        return loot;
    }

    public NonNullList<ItemStack> createLoot(Vault vault, Listener listener, RandomSource random) {
        NonNullList loot = NonNullList.m_122779_();
        if (this.lootTable != null) {
            LootTableGenerator generator = new LootTableGenerator(vault.get(Vault.VERSION), this.lootTable, this.itemQuantity);
            generator.generate(random);
            generator.getItems().forEachRemaining(arg_0 -> loot.add(arg_0));
        }
        loot.removeIf(ItemStack::m_41619_);
        NonNullList<ItemStack> specialLoot = this.createSpecialLoot(listener, random);
        for (int i = 0; i < loot.size() - 54 + specialLoot.size(); ++i) {
            loot.remove(random.nextInt(loot.size()));
        }
        loot.addAll(specialLoot);
        Collections.shuffle(loot);
        return loot;
    }

    public NonNullList<ItemStack> createSpecialLoot(@Nullable Listener listener, RandomSource random) {
        NonNullList loot = NonNullList.m_122779_();
        if (this.addArtifact) {
            float probability = this.artifactChance;
            if (listener != null) {
                probability = CommonEvents.ARTIFACT_CHANCE.invoke(listener, probability).getProbability();
            }
            if (random.nextFloat() < probability) {
                loot.add((Object)new ItemStack((ItemLike)ModItems.UNIDENTIFIED_ARTIFACT));
            }
        }
        if (random.nextFloat() < ModConfigs.AUGMENT.getDropChance()) {
            loot.add((Object)new ItemStack((ItemLike)ModItems.AUGMENT));
        }
        return loot;
    }

    public NonNullList<ItemStack> createLootForCommand(RandomSource random, int vaultLevel) {
        int i;
        NonNullList loot = NonNullList.m_122779_();
        if (this.lootTable != null) {
            LootTableGenerator generator = new LootTableGenerator(Version.v1_0, this.lootTable, 0.0f);
            generator.generate(random);
            generator.getItems().forEachRemaining(arg_0 -> loot.add(arg_0));
        }
        loot.removeIf(ItemStack::m_41619_);
        NonNullList<ItemStack> specialLoot = this.createSpecialLoot(null, random);
        for (i = 0; i < loot.size() - 54 + specialLoot.size(); ++i) {
            loot.remove(random.nextInt(loot.size()));
        }
        loot.addAll(specialLoot);
        Collections.shuffle(loot);
        loot.forEach(stack -> {
            Item patt3676$temp = stack.m_41720_();
            if (patt3676$temp instanceof VaultGearItem) {
                VaultGearItem lootItem = (VaultGearItem)patt3676$temp;
                lootItem.setItemLevel((ItemStack)stack, vaultLevel);
            }
        });
        for (i = 0; i < loot.size(); ++i) {
            ItemStack stack2 = (ItemStack)loot.get(i);
            Item item = stack2.m_41720_();
            if (!(item instanceof DataTransferItem)) continue;
            DataTransferItem lootItem = (DataTransferItem)item;
            loot.set(i, (Object)lootItem.convertStack(stack2, random));
        }
        return loot;
    }
}

