/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.entity.entity.SpiritEntity;
import iskallia.vault.util.EntityHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class EntityState
extends DataObject<EntityState>
implements INBTSerializable<CompoundTag> {
    public static final FieldRegistry FIELDS = new FieldRegistry();
    public static final FieldKey<Double> POS_X = (FieldKey)FieldKey.of("pos_x", Double.class).with(Version.v1_0, Adapters.DOUBLE, DISK.all()).register(FIELDS);
    public static final FieldKey<Double> POS_Y = (FieldKey)FieldKey.of("pos_y", Double.class).with(Version.v1_0, Adapters.DOUBLE, DISK.all()).register(FIELDS);
    public static final FieldKey<Double> POS_Z = (FieldKey)FieldKey.of("pos_z", Double.class).with(Version.v1_0, Adapters.DOUBLE, DISK.all()).register(FIELDS);
    public static final FieldKey<Float> YAW = (FieldKey)FieldKey.of("yaw", Float.class).with(Version.v1_0, Adapters.FLOAT, DISK.all()).register(FIELDS);
    public static final FieldKey<Float> PITCH = (FieldKey)FieldKey.of("pitch", Float.class).with(Version.v1_0, Adapters.FLOAT, DISK.all()).register(FIELDS);
    public static final FieldKey<GameType> GAME_MODE = (FieldKey)FieldKey.of("game_mode", GameType.class).with(Version.v1_0, Adapters.ofOrdinal(Enum::ordinal, GameType.values()), DISK.all()).register(FIELDS);
    public static final FieldKey<ResourceKey<Level>> WORLD = (FieldKey)FieldKey.ofResourceKey("world", Level.class).with(Version.v1_0, Adapters.ofResourceKey(Registry.f_122819_), DISK.all()).register(FIELDS);

    public EntityState() {
    }

    public EntityState(ServerPlayer player) {
        this(player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, player.m_146908_(), player.m_146909_(), player.f_8941_.m_9290_(), (ResourceKey<Level>)player.f_19853_.m_46472_());
    }

    public EntityState(double x, double y, double z, float yaw, float pitch, GameType gameMode, ResourceKey<Level> world) {
        this.set(POS_X, x);
        this.set(POS_Y, y);
        this.set(POS_Z, z);
        this.set(YAW, Float.valueOf(yaw));
        this.set(PITCH, Float.valueOf(pitch));
        this.set(GAME_MODE, gameMode);
        this.set(WORLD, world);
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128347_("PosX", this.get(POS_X).doubleValue());
        nbt.m_128347_("PosY", this.get(POS_Y).doubleValue());
        nbt.m_128347_("PosZ", this.get(POS_Z).doubleValue());
        nbt.m_128350_("Yaw", this.get(YAW).floatValue());
        nbt.m_128350_("Pitch", this.get(PITCH).floatValue());
        nbt.m_128405_("GameMode", this.get(GAME_MODE).ordinal());
        nbt.m_128359_("World", this.get(WORLD).m_135782_().toString());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.set(POS_X, nbt.m_128459_("PosX"));
        this.set(POS_Y, nbt.m_128459_("PosY"));
        this.set(POS_Z, nbt.m_128459_("PosZ"));
        this.set(YAW, Float.valueOf(nbt.m_128457_("Yaw")));
        this.set(PITCH, Float.valueOf(nbt.m_128457_("Pitch")));
        this.set(GAME_MODE, GameType.values()[nbt.m_128451_("GameMode")]);
        this.set(WORLD, ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("World"))));
    }

    public Vec3 getPos() {
        return new Vec3(this.get(POS_X).doubleValue(), this.get(POS_Y).doubleValue(), this.get(POS_Z).doubleValue());
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.getPos());
    }

    public boolean isLoaded() {
        ServerLevel target = ServerLifecycleHooks.getCurrentServer().m_129880_(this.get(WORLD));
        BlockPos pos = new BlockPos(this.get(POS_X).doubleValue(), this.get(POS_Y).doubleValue(), this.get(POS_Z).doubleValue());
        return target != null && target.m_46749_(pos);
    }

    public boolean isColliding(AABB entityCollisionBox) {
        ServerLevel target = ServerLifecycleHooks.getCurrentServer().m_129880_(this.get(WORLD));
        BlockPos pos = new BlockPos(this.get(POS_X).doubleValue(), this.get(POS_Y).doubleValue(), this.get(POS_Z).doubleValue());
        AABB targetBox = entityCollisionBox.m_82338_(pos);
        return target != null && EntityHelper.isColliding((Level)target, targetBox);
    }

    public EntityState move(double x, double y, double z) {
        EntityState movedState = this.copy();
        movedState.set(POS_X, this.get(POS_X) + x);
        movedState.set(POS_Y, this.get(POS_Y) + y);
        movedState.set(POS_Z, this.get(POS_Z) + z);
        return movedState;
    }

    private EntityState copy() {
        EntityState newState = new EntityState();
        for (FieldKey key : this.getFields().getKeys()) {
            this.getOptional(key).ifPresent(value -> newState.set(key, value));
        }
        return newState;
    }

    public void teleport(Entity entity) {
        Object e;
        ServerLevel target = ServerLifecycleHooks.getCurrentServer().m_129880_(this.get(WORLD));
        ServerLevel world = target != null ? target : ServerLifecycleHooks.getCurrentServer().m_129783_();
        Vec3 position = new Vec3(this.get(POS_X).doubleValue(), this.get(POS_Y).doubleValue(), this.get(POS_Z).doubleValue());
        Vec3 velocity = entity.m_20184_();
        if (!entity.m_20197_().isEmpty() && (e = entity.m_20197_().get(0)) instanceof SpiritEntity) {
            SpiritEntity spirit = (SpiritEntity)e;
            spirit.teleportOut();
        }
        if (entity instanceof Player || entity.f_19853_ != target) {
            VaultUtils.changeDimension(world, entity, position, velocity, this.get(YAW).floatValue(), this.get(PITCH).floatValue(), repositionedEntity -> {});
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.ifPresent(GAME_MODE, arg_0 -> ((ServerPlayer)player).m_143403_(arg_0));
        }
    }
}

