/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.data.key.registry.ISupplierKey;
import iskallia.vault.core.vault.PortalData;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.template.PlacementSettings;
import iskallia.vault.core.world.template.Template;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class PortalLogic
extends DataObject<PortalLogic>
implements ISupplierKey<PortalLogic> {
    public static final FieldRegistry FIELDS = new FieldRegistry();
    public static final FieldKey<PortalData.List> DATA = (FieldKey)FieldKey.of("data", PortalData.List.class).with(Version.v1_0, CompoundAdapter.of(PortalData.List::new), DISK.all().or(CLIENT.all())).register(FIELDS);

    public PortalLogic() {
        this.set(DATA, new PortalData.List());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient(Vault vault) {
    }

    public Stream<PortalData> getPortals() {
        return this.get(DATA).stream();
    }

    public Stream<PortalData> getPortals(ResourceLocation tag) {
        return this.get(DATA).stream().filter(data -> data.get(PortalData.TAGS).contains(tag));
    }

    public void addPortal(Template template, PlacementSettings settings, Collection<ResourceLocation> tags) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        Iterator<PartialTile> it = template.getTiles(Template.VAULT_PORTALS, settings);
        while (it.hasNext()) {
            PartialTile tile = it.next();
            if (tile.getPos().m_123341_() < minX) {
                minX = tile.getPos().m_123341_();
            }
            if (tile.getPos().m_123342_() < minY) {
                minY = tile.getPos().m_123342_();
            }
            if (tile.getPos().m_123343_() < minZ) {
                minZ = tile.getPos().m_123343_();
            }
            if (tile.getPos().m_123341_() > maxX) {
                maxX = tile.getPos().m_123341_();
            }
            if (tile.getPos().m_123342_() > maxY) {
                maxY = tile.getPos().m_123342_();
            }
            if (tile.getPos().m_123343_() <= maxZ) continue;
            maxZ = tile.getPos().m_123343_();
        }
        PortalData data = (PortalData)((PortalData)new PortalData().set(PortalData.MIN, new BlockPos(minX, minY, minZ))).set(PortalData.MAX, new BlockPos(maxX, maxY, maxZ));
        data.get(PortalData.TAGS).addAll(tags);
        this.get(DATA).add(data);
    }
}

