/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.enhancement;

import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.enhancement.EnhancementTask;
import iskallia.vault.world.data.ServerVaults;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EnhancementData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerEnhancements";
    protected List<EnhancementTask<?>> tasks = new ArrayList();

    public static List<EnhancementTask<?>> get(Player player) {
        return EnhancementData.get().tasks.stream().filter(task -> task.belongsTo((Entity)player)).collect(Collectors.toList());
    }

    public static void add(EnhancementTask<?> task) {
        EnhancementData.get().tasks.add(task);
        task.initServer(ServerLifecycleHooks.getCurrentServer());
    }

    public static void remove(Vault vault, UUID player) {
        EnhancementData.get().tasks.removeIf(task -> {
            if (task.belongsTo(vault) && task.belongsTo(player)) {
                task.releaseServer();
                return true;
            }
            return false;
        });
    }

    public static Map<UUID, EnhancementTask<?>> getForAltar(UUID uuid) {
        HashMap result = new HashMap();
        for (EnhancementTask<?> task : EnhancementData.get().tasks) {
            if (!task.getAltar().equals(uuid)) continue;
            result.put(task.getPlayer(), task);
        }
        return result;
    }

    @SubscribeEvent
    public static void onStartTick(ServerStartedEvent event) {
        EnhancementData enhancements = EnhancementData.get();
        enhancements.tasks.forEach(task -> task.initServer(event.getServer()));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        EnhancementData enhancements = EnhancementData.get();
        enhancements.tasks.removeIf(enhancement -> {
            if (ServerVaults.get(enhancement.getVault()).isEmpty()) {
                enhancement.releaseServer();
                return true;
            }
            return false;
        });
    }

    @SubscribeEvent
    public static void onServerStop(ServerStoppedEvent event) {
        EnhancementData.get().tasks.forEach(EnhancementTask::releaseServer);
    }

    public boolean m_77764_() {
        return true;
    }

    @Nonnull
    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag list = new ListTag();
        for (EnhancementTask<?> task : this.tasks) {
            Adapters.ENHANCEMENT_TASK.writeNbt(task).ifPresent(arg_0 -> list.add(arg_0));
        }
        nbt.m_128365_("tasks", (Tag)list);
        return nbt;
    }

    private static EnhancementData load(CompoundTag nbt) {
        EnhancementData data = new EnhancementData();
        ListTag list = nbt.m_128437_("tasks", 10);
        for (int i = 0; i < list.size(); ++i) {
            Adapters.ENHANCEMENT_TASK.readNbt((Tag)list.m_128728_(i)).ifPresent(data.tasks::add);
        }
        return data;
    }

    public static EnhancementData get() {
        return (EnhancementData)ServerLifecycleHooks.getCurrentServer().m_129783_().m_8895_().m_164861_(EnhancementData::load, EnhancementData::new, DATA_NAME);
    }
}

