/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.enhancement;

import iskallia.vault.block.VaultChestBlock;
import iskallia.vault.block.entity.VaultEnhancementAltarTileEntity;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.enhancement.IntFilterEnhancementTask;
import iskallia.vault.core.vault.stat.VaultChestType;
import iskallia.vault.core.world.roll.IntRoll;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;

public class LootChestsEnhancementTask
extends IntFilterEnhancementTask<Config> {
    public LootChestsEnhancementTask() {
    }

    public LootChestsEnhancementTask(Config config, UUID vault, UUID player, UUID altar, int requiredCount) {
        super(config, vault, player, altar, requiredCount);
    }

    @Override
    public void initServer(MinecraftServer server) {
        CommonEvents.CHEST_LOOT_GENERATION.post().register(this, event -> {
            if (!this.belongsTo((Entity)event.getPlayer())) {
                return;
            }
            if (!((Config)this.config).isValid(event.getState())) {
                return;
            }
            ++this.count;
        });
    }

    @Override
    public void releaseServer() {
        CommonEvents.CHEST_LOOT_GENERATION.release(this);
    }

    public static class Config
    extends IntFilterEnhancementTask.Config<LootChestsEnhancementTask> {
        private static final ArrayAdapter<VaultChestType> FILTER = Adapters.ofArray(VaultChestType[]::new, Adapters.ofEnum(VaultChestType.class, EnumAdapter.Mode.NAME));
        protected VaultChestType[] filter;

        public Config() {
        }

        public Config(String display, IntRoll range, VaultChestType ... filter) {
            super(display, range);
            this.filter = filter;
        }

        @Override
        public LootChestsEnhancementTask create(Vault vault, Player player, VaultEnhancementAltarTileEntity altar, RandomSource random) {
            return new LootChestsEnhancementTask(this, vault.get(Vault.ID), player.m_142081_(), altar.getUUID(), this.range.get(random));
        }

        public boolean isValid(BlockState state) {
            VaultChestType[] vaultChestTypeArray = state.m_60734_();
            if (!(vaultChestTypeArray instanceof VaultChestBlock)) {
                return false;
            }
            VaultChestBlock block = (VaultChestBlock)vaultChestTypeArray;
            for (VaultChestType type : this.filter) {
                if (block.getType() != type) continue;
                return true;
            }
            return false;
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                FILTER.writeNbt((VaultChestType)this.filter).ifPresent(tag -> nbt.m_128365_("filter", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.filter = FILTER.readNbt(nbt.m_128423_("filter")).orElse(new VaultChestType[0]);
        }
    }
}

