/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.influence;

import iskallia.vault.VaultMod;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Modifiers;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.influence.Favours;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.player.Completion;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.gear.charm.CharmHelper;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.gear.CharmItem;
import iskallia.vault.world.data.PlayerReputationData;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class Influences
extends DataObject<Influences> {
    private static final Map<VaultGod, List<String>> MESSAGES = new HashMap<VaultGod, List<String>>();
    public static final FieldRegistry FIELDS = new FieldRegistry();
    public static final FieldKey<Void> INITIALIZED = (FieldKey)FieldKey.of("initialized", Void.class).with(Version.v1_5, Adapters.ofVoid(), DISK.all()).register(FIELDS);
    public static final FieldKey<VaultGod> CURRENT = (FieldKey)FieldKey.of("current", VaultGod.class).with(Version.v1_5, Adapters.ofEnum(VaultGod.class, EnumAdapter.Mode.ORDINAL), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Favours> FAVOURS = (FieldKey)FieldKey.of("favours", Favours.class).with(Version.v1_5, CompoundAdapter.of(Favours::new), DISK.all().or(CLIENT.all())).register(FIELDS);

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    public void initServer(VirtualWorld world, Vault vault, Runner runner) {
        this.ifPresent(FAVOURS, favours -> favours.initServer(world, vault));
        CommonEvents.ALTAR_PROGRESS.in((Level)world).register(this, data -> {
            if (!data.isConsuming() || !data.getPlayer().m_142081_().equals(runner.getId())) {
                return;
            }
            CharmHelper.getCharms((LivingEntity)data.getPlayer()).forEach(charm -> {
                if (!charm.isUsable((Player)data.getPlayer())) {
                    return;
                }
                CharmItem.addUsedVault(charm.stack(), vault.get(Vault.ID));
            });
        });
    }

    public void tickServer(VirtualWorld world, Vault vault, Runner runner) {
        this.ifPresent(FAVOURS, favours -> favours.tickServer(world, vault));
        if (!this.has(INITIALIZED) && vault.get(Vault.CLOCK).get(TickClock.GLOBAL_TIME) > 200) {
            this.initialize(world, vault, runner);
            this.set(INITIALIZED);
        }
    }

    public void releaseServer() {
        this.ifPresent(FAVOURS, Modifiers::releaseServer);
    }

    public void onLeave(VirtualWorld world, Vault vault, Runner runner) {
        if (!this.has(CURRENT)) {
            return;
        }
        vault.getOptional(Vault.STATS).map(stats -> stats.get(runner)).ifPresent(stats -> {
            if (stats.getCompletion() == Completion.COMPLETED) {
                PlayerReputationData.addReputation(runner.getId(), this.get(CURRENT), 1);
            }
        });
    }

    public void initialize(VirtualWorld world, Vault vault, Runner runner) {
        if (!this.has(CURRENT)) {
            return;
        }
        int reputation = PlayerReputationData.getReputation(runner.getId(), this.get(CURRENT));
        this.set(FAVOURS, new Favours(runner.getId(), reputation));
        this.get(FAVOURS).initServer(world, vault);
        JavaRandom random = JavaRandom.ofInternal(vault.get(Vault.SEED) ^ runner.getId().getLeastSignificantBits());
        ResourceLocation id = VaultMod.id(this.get(CURRENT).getName().toLowerCase() + "_favours");
        Object2IntOpenHashMap modifiers = new Object2IntOpenHashMap();
        ModConfigs.VAULT_MODIFIER_POOLS.getRandom(id, reputation, random).forEach(arg_0 -> Influences.lambda$initialize$6((Object2IntMap)modifiers, arg_0));
        modifiers.forEach((modifier, count) -> this.get(FAVOURS).addModifier((VaultModifier<?>)modifier, (int)count, true, random));
        this.printGodMessage(runner, (Object2IntMap<VaultModifier<?>>)modifiers, random);
    }

    private void printGodMessage(Runner runner, Object2IntMap<VaultModifier<?>> modifiers, RandomSource random) {
        if (modifiers.isEmpty()) {
            return;
        }
        VaultGod god = this.get(CURRENT);
        String message = MESSAGES.get((Object)god).get(random.nextInt(MESSAGES.get((Object)god).size()));
        MutableComponent vgName = new TextComponent(god.getName()).m_130940_(god.getChatColor());
        vgName.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)god.getHoverChatComponent())));
        TextComponent txt = new TextComponent("");
        txt.m_7220_((Component)new TextComponent("[VG] ").m_130940_(ChatFormatting.DARK_PURPLE)).m_7220_((Component)vgName).m_7220_((Component)new TextComponent(": ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)new TextComponent(message));
        runner.getPlayer().ifPresent(arg_0 -> Influences.lambda$printGodMessage$10((MutableComponent)txt, modifiers, arg_0));
    }

    private static /* synthetic */ void lambda$printGodMessage$10(MutableComponent txt, Object2IntMap modifiers, ServerPlayer player) {
        player.m_6352_((Component)txt, Util.f_137441_);
        modifiers.forEach((modifier, count) -> {
            MutableComponent info = new TextComponent(modifier.getDisplayDescriptionFormatted((int)count)).m_130940_(ChatFormatting.DARK_GRAY);
            player.m_6352_((Component)info, Util.f_137441_);
        });
    }

    private static /* synthetic */ void lambda$initialize$6(Object2IntMap modifiers, VaultModifier modifier) {
        modifiers.put((Object)modifier, modifiers.getOrDefault((Object)modifier, 0) + 1);
    }

    static {
        ArrayList<String> velara = new ArrayList<String>();
        velara.add("Our domain's ground will carve a path.");
        velara.add("Tread upon our domain with care and it will respond in kind.");
        velara.add("May your desire blossom into a wildfire.");
        velara.add("Creation bends to our will.");
        MESSAGES.put(VaultGod.VELARA, velara);
        ArrayList<String> tenos = new ArrayList<String>();
        tenos.add("May foresight guide your step.");
        tenos.add("Careful planning and strategy may lead you.");
        tenos.add("A set choice; followed through and flawlessly executed.");
        tenos.add("Chance's hand may favour your goals.");
        MESSAGES.put(VaultGod.TENOS, tenos);
        ArrayList<String> wendarr = new ArrayList<String>();
        wendarr.add("Seize the opportunity.");
        wendarr.add("A single instant, stretched to infinity.");
        wendarr.add("Your future glows golden with possibility.");
        wendarr.add("Hasten and value every passing moment.");
        MESSAGES.put(VaultGod.WENDARR, wendarr);
        ArrayList<String> idona = new ArrayList<String>();
        idona.add("Enforce your path through obstacles.");
        idona.add("Our vigor may aid your conquest.");
        idona.add("Cherish this mote of my might.");
        idona.add("A tempest incarnate.");
        MESSAGES.put(VaultGod.IDONA, idona);
    }
}

