/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.influence;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.StringRepresentable;

public enum VaultGod implements StringRepresentable
{
    VELARA("Velara", "The Benevolent", ChatFormatting.GREEN),
    TENOS("Tenos", "The Omniscient", ChatFormatting.AQUA),
    WENDARR("Wendarr", "The Timekeeper", ChatFormatting.GOLD),
    IDONA("Idona", "The Malevolent", ChatFormatting.RED);

    private final String name;
    private final String title;
    private final ChatFormatting color;

    private VaultGod(String name, String title, ChatFormatting color) {
        this.name = name;
        this.title = title;
        this.color = color;
    }

    public static VaultGod fromName(String name) {
        for (VaultGod type : VaultGod.values()) {
            if (!name.equalsIgnoreCase(type.getName())) continue;
            return type;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public int getColor() {
        return this.color.m_126665_();
    }

    public ChatFormatting getChatColor() {
        return this.color;
    }

    @Nonnull
    public String m_7912_() {
        return this.getName().toLowerCase();
    }

    public Component getHoverChatComponent() {
        return new TextComponent("[Vault God] ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent(this.name + ", " + this.title).m_130940_(this.color));
    }

    public Component getIdolDescription() {
        String s = this.getName().endsWith("s") ? "" : "s";
        return new TextComponent(String.format("%s'%s Idol", this.getName(), s)).m_130940_(this.getChatColor());
    }

    public MutableComponent getChosenPrefix() {
        String prefix = "[" + this.getName().charAt(0) + "C] ";
        MutableComponent cmp = new TextComponent(prefix).m_130940_(this.color);
        String s = this.getName().endsWith("s") ? "" : "s";
        MutableComponent hover = new TextComponent(String.format("%s'%s Chosen", this.getName(), s)).m_130940_(this.getChatColor());
        cmp.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hover)));
        return cmp;
    }

    public VaultGod getOther(Random rand) {
        int i;
        while ((i = rand.nextInt(VaultGod.values().length)) == this.ordinal()) {
        }
        return VaultGod.values()[i];
    }
}

