/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.modifier.modifier;

import com.google.gson.annotations.Expose;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.TemplateGenerationEvent;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.reputation.ScalarReputationProperty;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.processor.tile.TileProcessor;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.core.world.template.EmptyTemplate;
import iskallia.vault.core.world.template.JigsawTemplate;
import iskallia.vault.core.world.template.PlacementSettings;
import iskallia.vault.core.world.template.Template;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class DecoratorAddModifier
extends VaultModifier<Properties> {
    private static final int DEFAULT_GENERATION_ATTEMPTS = 48;

    public DecoratorAddModifier(ResourceLocation id, Properties properties, VaultModifier.Display display) {
        super(id, properties, display);
        this.setDescriptionFormatter((t, p, s) -> t.formatted(p.attemptsPerChunk * s, p.attemptsPerChunk * s > 1 ? "s" : ""));
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault, ModifierContext context) {
        CommonEvents.TEMPLATE_GENERATION.in((LevelWriter)world).at(TemplateGenerationEvent.Phase.POST).register(context.getUUID(), data -> {
            if (data.getTemplate().getParent() instanceof EmptyTemplate) {
                return;
            }
            ProcessorContext processorContext = new ProcessorContext(vault, data.getRandom());
            for (int i = 0; i < ((Properties)this.properties).getAttemptsPerChunk(context); ++i) {
                TileProcessor processor;
                int x = data.getRandom().nextInt(16) + data.getChunkPos().f_45578_ * 16;
                int z = data.getRandom().nextInt(16) + data.getChunkPos().f_45579_ * 16;
                int y = data.getRandom().nextInt(64);
                BlockPos pos = new BlockPos(x, y, z);
                ServerLevelAccessor serverLevelAccessor = data.getWorld();
                BlockState state = serverLevelAccessor.m_8055_(pos);
                if (state.m_60734_() != Blocks.f_50016_ || ((Properties)this.properties).requireConditions && (!serverLevelAccessor.m_8055_(pos.m_7494_()).m_60795_() || !serverLevelAccessor.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)serverLevelAccessor, pos, Direction.UP))) continue;
                PartialTile tile = ((Properties)this.properties).output.copy().setPos(pos);
                PlacementSettings settings = data.getTemplate().getSettings().copy();
                Template patt3235$temp = data.getTemplate().getParent();
                if (patt3235$temp instanceof JigsawTemplate) {
                    JigsawTemplate jigsaw = (JigsawTemplate)patt3235$temp;
                    jigsaw.getConfigurator().accept(settings);
                }
                Iterator<TileProcessor> iterator = settings.getTileProcessors().iterator();
                while (iterator.hasNext() && (tile = (processor = iterator.next()).process(tile, processorContext)) != null) {
                }
                if (tile == null) continue;
                tile.place((CommonLevelAccessor)serverLevelAccessor, pos, 3);
            }
        });
    }

    public static class Properties {
        @Expose
        private final PartialTile output;
        @Expose
        private final int attemptsPerChunk;
        @Expose
        private final boolean requireConditions;
        @Expose
        private final ScalarReputationProperty reputation;

        public Properties(PartialTile output, ScalarReputationProperty reputation) {
            this(output, 48, true, reputation);
        }

        public Properties(PartialTile output, int attemptsPerChunk, boolean requireConditions, ScalarReputationProperty reputation) {
            this.output = output;
            this.attemptsPerChunk = attemptsPerChunk;
            this.requireConditions = requireConditions;
            this.reputation = reputation;
        }

        public PartialTile getOutput() {
            return this.output;
        }

        public int getAttemptsPerChunk(ModifierContext context) {
            return this.reputation != null ? this.reputation.apply(this.attemptsPerChunk, context) : this.attemptsPerChunk;
        }

        public boolean requireConditions() {
            return this.requireConditions;
        }
    }
}

