/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.modifier.modifier;

import com.google.gson.annotations.Expose;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.Map;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.eventbus.api.EventPriority;

public class EntityEffectModifier
extends VaultModifier<Properties> {
    public EntityEffectModifier(ResourceLocation id, Properties properties, VaultModifier.Display display) {
        super(id, properties, display);
        this.setDescriptionFormatter((t, p, s) -> t.formatted((int)Math.abs(p.getChance() * (double)s * 100.0)));
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault, ModifierContext context) {
        CommonEvents.ENTITY_SPAWN.register((Object)context.getUUID(), EventPriority.HIGHEST, event -> {
            if (event.getEntity().f_19853_ != world) {
                return;
            }
            Entity patt1351$temp = event.getEntity();
            if (!(patt1351$temp instanceof LivingEntity)) {
                return;
            }
            LivingEntity entity = (LivingEntity)patt1351$temp;
            Map<MobEffectInstance, Double> effects = ((ILivingEntityAccessor)entity).getEffects();
            if (((Properties)this.properties).filter.test((Entity)entity)) {
                for (Map.Entry<MobEffectInstance, Double> entry : effects.entrySet()) {
                    if (entry.getKey().m_19544_() != ((Properties)this.properties).effect) continue;
                    effects.put(entry.getKey(), entry.getValue() + ((Properties)this.properties).chance);
                    return;
                }
                effects.put(new MobEffectInstance(((Properties)this.properties).effect, 999999, ((Properties)this.properties).getAmplifier()), ((Properties)this.properties).chance);
            }
        });
        CommonEvents.ENTITY_SPAWN.register((Object)context.getUUID(), EventPriority.LOWEST, event -> {
            if (event.getEntity().f_19853_ != world) {
                return;
            }
            Entity patt2235$temp = event.getEntity();
            if (!(patt2235$temp instanceof LivingEntity)) {
                return;
            }
            LivingEntity entity = (LivingEntity)patt2235$temp;
            Map<MobEffectInstance, Double> effects = ((ILivingEntityAccessor)entity).getEffects();
            Random random = entity.f_19853_.m_5822_();
            effects.forEach((instance, chance) -> {
                if (random.nextDouble() < chance) {
                    entity.m_7292_(instance);
                }
            });
        });
    }

    public static interface ILivingEntityAccessor {
        public Map<MobEffectInstance, Double> getEffects();
    }

    public static class Properties {
        @Expose
        private final EntityPredicate filter;
        @Expose
        private final MobEffect effect;
        @Expose
        private final int amplifier;
        @Expose
        private final double chance;

        public Properties(EntityPredicate filter, MobEffect effect, int amplifier, double chance) {
            this.filter = filter;
            this.effect = effect;
            this.amplifier = amplifier;
            this.chance = chance;
        }

        public EntityPredicate getFilter() {
            return this.filter;
        }

        public MobEffect getEffect() {
            return this.effect;
        }

        public int getAmplifier() {
            return this.amplifier;
        }

        public double getChance() {
            return this.chance;
        }
    }
}

