/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.modifier.modifier;

import com.google.gson.annotations.Expose;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.LootGenerationEvent;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.world.data.item.ItemPredicate;
import iskallia.vault.core.world.loot.generator.LootGenerator;
import iskallia.vault.core.world.loot.generator.TieredLootTableGenerator;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;

public class LootItemQuantityModifier
extends VaultModifier<Properties> {
    public LootItemQuantityModifier(ResourceLocation id, Properties properties, VaultModifier.Display display) {
        super(id, properties, display);
        this.setDescriptionFormatter((t, p, s) -> t.formatted((int)Math.abs(p.getPercentage() * (float)s * 100.0f)));
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault, ModifierContext context) {
        CommonEvents.LOOT_GENERATION.pre().register(context.getUUID(), data -> this.getGenerator(vault, (LootGenerationEvent.Data)data, context).ifPresent(generator -> {
            if (((Properties)this.properties).filter == null) {
                generator.itemQuantity += ((Properties)this.properties).getPercentage();
            } else {
                generator.itemQuantityOverrides.put(((Properties)this.properties).filter, Float.valueOf(((Properties)this.properties).getPercentage()));
            }
        }));
        CommonEvents.LOOT_GENERATION.post().register(context.getUUID(), data -> this.getGenerator(vault, (LootGenerationEvent.Data)data, context).ifPresent(generator -> {
            if (((Properties)this.properties).filter == null) {
                generator.itemQuantity -= ((Properties)this.properties).getPercentage();
            } else {
                generator.itemQuantityOverrides.remove(((Properties)this.properties).filter);
            }
        }));
    }

    public Optional<TieredLootTableGenerator> getGenerator(Vault vault, LootGenerationEvent.Data data, ModifierContext context) {
        LootGenerator lootGenerator = data.getGenerator();
        if (!(lootGenerator instanceof TieredLootTableGenerator)) {
            return Optional.empty();
        }
        TieredLootTableGenerator generator = (TieredLootTableGenerator)lootGenerator;
        if (generator.source == null) {
            return Optional.empty();
        }
        UUID uuid = generator.source.m_142081_();
        if (!vault.get(Vault.LISTENERS).contains(uuid)) {
            return Optional.empty();
        }
        if (context.hasTarget() && !context.getTarget().equals(uuid)) {
            return Optional.empty();
        }
        return Optional.of(generator);
    }

    public static class Properties {
        @Expose
        private final ItemPredicate filter;
        @Expose
        private final float percentage;

        public Properties(ItemPredicate filter, float percentage) {
            this.filter = filter;
            this.percentage = percentage;
        }

        public ItemPredicate getFilter() {
            return this.filter;
        }

        public float getPercentage() {
            return this.percentage;
        }
    }
}

