/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.modifier.modifier;

import com.google.gson.annotations.Expose;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.player.Completion;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.stat.StatsCollector;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.item.bottle.BottleItem;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.world.data.PhoenixModifierSnapshotData;
import iskallia.vault.world.data.ServerVaults;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerInventoryRestoreModifier
extends VaultModifier<Properties> {
    private static final String RESTORE_FLAG = "the_vault_restore_inventory";

    public PlayerInventoryRestoreModifier(ResourceLocation id, Properties properties, VaultModifier.Display display) {
        super(id, properties, display);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!player.m_6084_() || !(player.f_19853_ instanceof ServerLevel)) {
            return;
        }
        if (!player.m_19880_().contains(RESTORE_FLAG)) {
            return;
        }
        ServerLevel world = (ServerLevel)event.player.f_19853_;
        PhoenixModifierSnapshotData data = PhoenixModifierSnapshotData.get(world);
        if (data.hasSnapshot(player)) {
            data.restoreSnapshot(player);
        }
        player.m_20137_(RESTORE_FLAG);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sPlayer = (ServerPlayer)livingEntity;
        ServerVaults.get((Level)sPlayer.m_183503_()).ifPresent(vault -> {
            ModifierContext actualContext;
            if (!vault.has(Vault.MODIFIERS)) {
                InventoryUtil.makeItemsRotten((Player)sPlayer);
                return;
            }
            boolean hasRestoreModifier = false;
            PlayerInventoryRestoreModifier instantRestoreModifier = null;
            for (VaultModifier<?> modifier : vault.get(Vault.MODIFIERS).getModifiers()) {
                if (!(modifier instanceof PlayerInventoryRestoreModifier)) continue;
                PlayerInventoryRestoreModifier restoreModifier = (PlayerInventoryRestoreModifier)modifier;
                hasRestoreModifier = true;
                if (!((Properties)restoreModifier.properties()).isInstantRevival()) continue;
                instantRestoreModifier = restoreModifier;
                break;
            }
            if (instantRestoreModifier != null && !event.getSource().m_19378_() && (actualContext = (ModifierContext)vault.get(Vault.MODIFIERS).getContexts(instantRestoreModifier).findFirst().orElse(null)) != null) {
                sPlayer.m_21153_(sPlayer.m_21233_());
                sPlayer.m_21219_();
                sPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 300, 1));
                sPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 200, 2));
                sPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 1));
                sPlayer.m_183503_().m_5594_(null, sPlayer.m_142538_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
                event.setCanceled(true);
                actualContext.setExpired();
                return;
            }
            InventoryUtil.makeItemsRotten((Player)sPlayer);
            if (!hasRestoreModifier) {
                return;
            }
            if (!vault.has(Vault.STATS)) {
                return;
            }
            StatsCollector statsCollector = vault.get(Vault.STATS);
            StatCollector playerStatCollector = statsCollector.get(sPlayer.m_142081_());
            if (playerStatCollector == null) {
                return;
            }
            int experience = ModConfigs.VAULT_STATS.getStatsExperience(playerStatCollector);
            int durabilityExperience = experience - ModConfigs.VAULT_STATS.getFreeExperienceNotDealtAsDurabilityDamage();
            int durabilityDamage = (int)((float)durabilityExperience * ModConfigs.VAULT_STATS.getPercentOfExperienceDealtAsDurabilityDamage());
            if (durabilityDamage <= 0) {
                return;
            }
            InventoryUtil.findAllItems((Player)sPlayer).forEach(itemAccess -> {
                ItemStack foundStack = itemAccess.getStack();
                if (foundStack.m_41720_() instanceof VaultGearItem && foundStack.m_41763_() && !(foundStack.m_41720_() instanceof BottleItem) && !VaultGearData.read(foundStack).get(ModGearAttributes.SOULBOUND, VaultGearAttributeTypeMerger.anyTrue()).booleanValue()) {
                    foundStack.m_41622_(durabilityDamage, (LivingEntity)sPlayer, pl -> pl.m_21190_(InteractionHand.MAIN_HAND));
                    itemAccess.setStack(foundStack);
                }
            });
        });
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault, ModifierContext context) {
        CommonEvents.ENTITY_DEATH.register(context.getUUID(), event -> {
            if (event.isCanceled()) {
                return;
            }
            LivingEntity patt7212$temp = event.getEntityLiving();
            if (!(patt7212$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt7212$temp;
            if (!player.m_183503_().equals((Object)world)) {
                return;
            }
            if (!((Properties)this.properties()).isInstantRevival()) {
                PhoenixModifierSnapshotData snapshotData = PhoenixModifierSnapshotData.get(player.m_183503_());
                if (snapshotData.hasSnapshot((Player)player)) {
                    snapshotData.removeSnapshot((Player)player);
                }
                snapshotData.createSnapshot((Player)player);
                player.m_19880_().add(RESTORE_FLAG);
            }
        });
    }

    @Override
    public void onListenerAdd(VirtualWorld world, Vault vault, ModifierContext context, Listener listener) {
        vault.getOptional(Vault.STATS).map(stats -> stats.get(listener)).ifPresent(stats -> {
            stats.modify(StatCollector.OBJECTIVE_EXP_MULTIPLIER, m -> Float.valueOf(m.floatValue() * ((Properties)this.properties()).experienceMultiplierOnSuccess()));
            stats.modify(StatCollector.BONUS_EXP_MULTIPLIER, m -> Float.valueOf(m.floatValue() * ((Properties)this.properties()).experienceMultiplierOnSuccess()));
        });
    }

    @Override
    public void onListenerRemove(VirtualWorld world, Vault vault, ModifierContext context, Listener listener) {
        vault.ifPresent(Vault.STATS, stats -> {
            StatCollector statCollector = stats.get(listener);
            if (statCollector == null || statCollector.getCompletion() != Completion.FAILED) {
                return;
            }
            statCollector.modify(StatCollector.OBJECTIVE_EXP_MULTIPLIER, m -> Float.valueOf(m.floatValue() * ((Properties)this.properties).experienceMultiplierOnDeath()));
            statCollector.modify(StatCollector.BONUS_EXP_MULTIPLIER, m -> Float.valueOf(m.floatValue() * ((Properties)this.properties).experienceMultiplierOnDeath()));
        });
    }

    public static class Properties {
        @Expose
        private final boolean preventsArtifact;
        @Expose
        private final float experienceMultiplierOnDeath;
        @Expose
        private final float experienceMultiplierOnSuccess;
        @Expose
        private final boolean isInstantRevival;

        public Properties(boolean preventsArtifact, float experienceMultiplierOnDeath, float experienceMultiplierOnSuccess, boolean isInstantRevival) {
            this.preventsArtifact = preventsArtifact;
            this.experienceMultiplierOnDeath = experienceMultiplierOnDeath;
            this.experienceMultiplierOnSuccess = experienceMultiplierOnSuccess;
            this.isInstantRevival = isInstantRevival;
        }

        public boolean preventsArtifact() {
            return this.preventsArtifact;
        }

        public float experienceMultiplierOnDeath() {
            return this.experienceMultiplierOnDeath;
        }

        public float experienceMultiplierOnSuccess() {
            return this.experienceMultiplierOnSuccess;
        }

        public boolean isInstantRevival() {
            return this.isInstantRevival;
        }
    }
}

