/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.modifier.modifier;

import com.google.gson.annotations.Expose;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.reputation.ScalarReputationProperty;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.util.calc.PlayerStat;
import net.minecraft.resources.ResourceLocation;

public class PlayerStatModifier
extends VaultModifier<Properties> {
    public PlayerStatModifier(ResourceLocation id, Properties properties, VaultModifier.Display display) {
        super(id, properties, display);
        this.setDescriptionFormatter((t, p, s) -> t.formatted((int)(p.addend * (float)s * 100.0f)));
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault, ModifierContext context) {
        CommonEvents.PLAYER_STAT.register(context.getUUID(), data -> {
            if (data.getStat() != ((Properties)this.properties).stat) {
                return;
            }
            if (!vault.get(Vault.LISTENERS).contains(data.getEntity().m_142081_())) {
                return;
            }
            if (context.hasTarget() && !context.getTarget().equals(data.getEntity().m_142081_())) {
                return;
            }
            data.setValue(data.getValue() + ((Properties)this.properties).getAddend(context));
        });
    }

    public static class Properties {
        @Expose
        private final PlayerStat stat;
        @Expose
        private final float addend;
        @Expose
        private final ScalarReputationProperty reputation;

        public Properties(PlayerStat stat, float addend, ScalarReputationProperty reputation) {
            this.stat = stat;
            this.addend = addend;
            this.reputation = reputation;
        }

        public PlayerStat getStat() {
            return this.stat;
        }

        public float getAddend() {
            return this.addend;
        }

        public float getAddend(ModifierContext context) {
            return this.reputation != null ? this.reputation.apply(this.addend, context) : this.addend;
        }
    }
}

