/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.modifier.modifier;

import com.google.gson.annotations.Expose;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.item.tool.ToolItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SpawnerMobsModifier
extends VaultModifier<Properties> {
    public SpawnerMobsModifier(ResourceLocation id, Properties properties, VaultModifier.Display display) {
        super(id, properties, display);
        this.setDescriptionFormatter((t, p, s) -> t.formatted((int)Math.abs(p.getIncrease() * (double)s * 100.0)));
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault, ModifierContext context) {
        CommonEvents.SURFACE_GENERATION.in(world).register(context.getUUID(), data -> data.getChunk().m_5928_().forEach(pos -> {
            if (ToolItem.SPAWNER_ID.equals((Object)data.getGenRegion().m_8055_(pos).m_60734_().getRegistryName())) {
                CompoundTag nbt = data.getChunk().m_8049_(pos);
                if (nbt == null) {
                    nbt = new CompoundTag();
                    nbt.m_128405_("x", pos.m_123341_());
                    nbt.m_128405_("y", pos.m_123342_());
                    nbt.m_128405_("z", pos.m_123343_());
                    data.getChunk().m_5604_(nbt);
                }
                CompoundTag spawner = nbt.m_128469_("Spawner");
                CompoundTag manager = spawner.m_128469_("Manager");
                CompoundTag modifiers = manager.m_128469_("AttemptModifiers");
                modifiers.m_128347_(context.getUUID().toString(), ((Properties)this.properties).getIncrease());
                manager.m_128365_("AttemptModifiers", (Tag)modifiers);
                spawner.m_128365_("Manager", (Tag)manager);
                nbt.m_128365_("Spawner", (Tag)spawner);
                BlockEntity existing = data.getGenRegion().m_7702_(pos);
                if (existing != null) {
                    existing.m_142466_(nbt);
                }
            }
        }));
    }

    public static class Properties {
        @Expose
        private final double increase;

        public Properties(double increase) {
            this.increase = increase;
        }

        public double getIncrease() {
            return this.increase;
        }
    }
}

