/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.vault.LegacyBlockPosAdapter;
import iskallia.vault.core.data.adapter.vault.RegistryKeyAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.LootTableKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.entity.EntityScaler;
import iskallia.vault.entity.VaultBoss;
import iskallia.vault.entity.entity.FighterEntity;
import iskallia.vault.init.ModConfigs;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class KillBossObjective
extends Objective {
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of("kill_boss", Objective.class).with(Version.v1_0, (Objective)((Object)((Supplier<Objective>)KillBossObjective::new)));
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<UUID> BOSS_ID = (FieldKey)FieldKey.of("boss_id", UUID.class).with(Version.v1_0, Adapters.UUID.asNullable(), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<ResourceLocation> BOSS_TYPE = (FieldKey)FieldKey.of("boss_type", ResourceLocation.class).with(Version.v1_0, Adapters.IDENTIFIER, DISK.all()).register(FIELDS);
    public static final FieldKey<BlockPos> BOSS_POS = (FieldKey)FieldKey.of("boss_pos", BlockPos.class).with(Version.v1_0, LegacyBlockPosAdapter.create().asNullable(), DISK.all()).register(FIELDS);
    public static final FieldKey<String> BOSS_NAME = (FieldKey)FieldKey.of("boss_name", String.class).with(Version.v1_0, Adapters.UTF_8.asNullable(), DISK.all()).register(FIELDS);
    public static final FieldKey<Void> BOSS_DEAD = (FieldKey)FieldKey.of("boss_dead", Void.class).with(Version.v1_0, Adapters.ofVoid(), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<LootTableKey> LOOT_TABLE = (FieldKey)FieldKey.of("loot_table", LootTableKey.class).with(Version.v1_0, RegistryKeyAdapter.of(() -> VaultRegistry.LOOT_TABLE).asNullable(), DISK.all()).register(FIELDS);

    protected KillBossObjective() {
    }

    public static Objective ofStandardConfig(int level, RandomSource random) {
        EntityType<?> type = ModConfigs.VAULT_MOBS.getForLevel((int)level).BOSS_POOL.getRandom(random).orElseThrow().getType();
        return (Objective)((Objective)new KillBossObjective().set(BOSS_TYPE, type.getRegistryName())).set(BOSS_NAME, "Boss");
    }

    public static Objective ofRaffleConfig(String name, int level, RandomSource random) {
        EntityType<?> type = ModConfigs.VAULT_MOBS.getForLevel((int)level).RAFFLE_BOSS_POOL.getRandom(random).orElseThrow().getType();
        return (Objective)((Objective)new KillBossObjective().set(BOSS_TYPE, type.getRegistryName())).set(BOSS_NAME, name);
    }

    @Override
    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.ENTITY_DEATH.register(this, event -> {
            if (event.getEntity().m_142081_().equals(this.get(BOSS_ID))) {
                this.set(BOSS_DEAD);
            }
        });
        super.initServer(world, vault);
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault) {
        if (this.get(BOSS_ID) == null) {
            if (this.get(BOSS_POS) == null) {
                return;
            }
            this.spawnBoss(world, vault, this.get(BOSS_POS));
        }
        if (this.has(BOSS_DEAD)) {
            super.tickServer(world, vault);
        }
    }

    @Override
    public void tickListener(VirtualWorld world, Vault vault, Listener listener) {
        if (this.has(BOSS_DEAD)) {
            super.tickListener(world, vault, listener);
        }
    }

    private Entity spawnBoss(VirtualWorld world, Vault vault, BlockPos pos) {
        EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(this.get(BOSS_TYPE));
        if (type == null) {
            return null;
        }
        LivingEntity boss = (LivingEntity)type.m_20615_((Level)world);
        if (boss == null) {
            return null;
        }
        boss.m_6593_((Component)new TextComponent(this.get(BOSS_NAME)));
        boss.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.2, (double)pos.m_123343_() + 0.5, world.f_46441_.nextFloat() * 360.0f, 0.0f);
        world.m_8847_((Entity)boss);
        this.set(BOSS_ID, boss.m_142081_());
        if (boss instanceof Mob) {
            Mob mob = (Mob)boss;
            mob.m_21530_();
        }
        if (boss instanceof FighterEntity) {
            FighterEntity fighter = (FighterEntity)boss;
            fighter.changeSize(2.0f);
            fighter.bossInfo.m_8321_(true);
        }
        if (boss instanceof VaultBoss) {
            VaultBoss vaultBoss = (VaultBoss)boss;
            vaultBoss.getServerBossInfo().m_8321_(true);
        }
        EntityScaler.scale(vault, boss);
        for (int i = 0; i < 5; ++i) {
            LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)world);
            if (bolt == null) continue;
            bolt.m_20219_(Vec3.m_82539_((Vec3i)pos.m_142082_(world.f_46441_.nextInt(100) - 50, 0, world.f_46441_.nextInt(100) - 50)));
            bolt.m_20874_(true);
            world.m_7967_((Entity)bolt);
        }
        return boss;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean render(Vault vault, PoseStack matrixStack, Window window, float partialTicks, Player player) {
        if (this.has(BOSS_DEAD)) {
            boolean rendered = false;
            for (Objective objective : (Objective.ObjList)this.get(CHILDREN)) {
                rendered |= objective.render(vault, matrixStack, window, partialTicks, player);
            }
            if (rendered) {
                return true;
            }
        }
        int width = window.m_85445_();
        int height = window.m_85446_();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        MutableComponent txt = new TextComponent("Kill the Boss!").m_130940_(ChatFormatting.AQUA).m_130940_(ChatFormatting.BOLD);
        Minecraft.m_91087_().f_91062_.m_92733_(txt.m_7532_(), 8.0f, (float)(height - 54), -1, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
        buffer.m_109911_();
        return true;
    }

    @Override
    public boolean isActive(Vault vault, Objective objective) {
        if (objective == this && !this.has(BOSS_DEAD)) {
            return true;
        }
        for (Objective child : (Objective.ObjList)this.get(CHILDREN)) {
            if (!child.isActive(vault, objective)) continue;
            return true;
        }
        return false;
    }
}

