/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.VaultMod;
import iskallia.vault.block.MonolithBlock;
import iskallia.vault.block.PlaceholderBlock;
import iskallia.vault.block.entity.MonolithTileEntity;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.LootTableKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.BlockSetEvent;
import iskallia.vault.core.event.common.BlockUseEvent;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.objective.KillBossObjective;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.tile.PartialBlockState;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.loot.generator.LootTableGenerator;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.gear.DataInitializationItem;
import iskallia.vault.item.gear.DataTransferItem;
import iskallia.vault.item.gear.VaultLevelItem;
import iskallia.vault.network.message.MonolithIgniteMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class MonolithObjective
extends Objective {
    public static final ResourceLocation HUD = VaultMod.id("textures/gui/monolith/hud.png");
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of("monolith", Objective.class).with(Version.v1_2, (Objective)((Object)((Supplier<Objective>)MonolithObjective::new)));
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<Integer> COUNT = (FieldKey)FieldKey.of("count", Integer.class).with(Version.v1_0, Adapters.INT_SEGMENTED_3, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> TARGET = (FieldKey)FieldKey.of("target", Integer.class).with(Version.v1_0, Adapters.INT_SEGMENTED_3, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Integer> BASE_TARGET = (FieldKey)FieldKey.of("base_target", Integer.class).with(Version.v1_25, Adapters.INT_SEGMENTED_3, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Float> OBJECTIVE_PROBABILITY = (FieldKey)FieldKey.of("objective_probability", Float.class).with(Version.v1_2, Adapters.FLOAT, DISK.all()).register(FIELDS);
    public static final FieldKey<ResourceLocation> STACK_MODIFIER_POOL = (FieldKey)FieldKey.of("stack_modifier_pool", ResourceLocation.class).with(Version.v1_22, Adapters.IDENTIFIER, DISK.all()).register(FIELDS);
    public static final FieldKey<ResourceLocation> OVER_STACK_MODIFIER_POOL = (FieldKey)FieldKey.of("over_stack_modifier_pool", ResourceLocation.class).with(Version.v1_22, Adapters.IDENTIFIER, DISK.all()).register(FIELDS);
    public static final FieldKey<ResourceLocation> OVER_STACK_LOOT_TABLE = (FieldKey)FieldKey.of("loot_table", ResourceLocation.class).with(Version.v1_22, Adapters.IDENTIFIER, DISK.all()).register(FIELDS);

    protected MonolithObjective() {
    }

    protected MonolithObjective(int target, float objectiveProbability, ResourceLocation stackModifierPool, ResourceLocation overStackModifierPool, ResourceLocation lootTable) {
        this.set(COUNT, 0);
        this.set(TARGET, target);
        this.set(BASE_TARGET, target);
        this.set(OBJECTIVE_PROBABILITY, Float.valueOf(objectiveProbability));
        this.set(STACK_MODIFIER_POOL, stackModifierPool);
        this.set(OVER_STACK_MODIFIER_POOL, overStackModifierPool);
        this.set(OVER_STACK_LOOT_TABLE, lootTable);
    }

    public static MonolithObjective of(int target, float objectiveProbability, ResourceLocation stackModifierPool, ResourceLocation overStackModifierPool, ResourceLocation overStackLootTable) {
        return new MonolithObjective(target, objectiveProbability, stackModifierPool, overStackModifierPool, overStackLootTable);
    }

    @Override
    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.OBJECTIVE_PIECE_GENERATION.register(this, data -> this.ifPresent(OBJECTIVE_PROBABILITY, probability -> data.setProbability(probability.floatValue())));
        CommonEvents.BLOCK_USE.in((Level)world).at(BlockUseEvent.Phase.HEAD).of(ModBlocks.MONOLITH).register(this, data -> {
            MonolithTileEntity tile;
            BlockEntity patt9339$temp;
            boolean overStacking;
            if (data.getHand() != InteractionHand.MAIN_HAND) {
                data.setResult(InteractionResult.SUCCESS);
                return;
            }
            BlockPos pos = data.getPos();
            if (data.getState().m_61143_(MonolithBlock.STATE) != MonolithBlock.State.EXTINGUISHED) {
                return;
            }
            if (vault.get(Vault.LISTENERS).getObjectivePriority(data.getPlayer().m_142081_(), this) != 0) {
                return;
            }
            boolean bl = overStacking = this.get(COUNT) >= this.get(TARGET);
            if (overStacking) {
                world.m_7731_(pos, (BlockState)world.m_8055_(pos).m_61124_(MonolithBlock.STATE, (Comparable)((Object)MonolithBlock.State.DESTROYED)), 3);
            } else {
                world.m_7731_(pos, (BlockState)world.m_8055_(pos).m_61124_(MonolithBlock.STATE, (Comparable)((Object)MonolithBlock.State.LIT)), 3);
            }
            this.playActivationEffects(world, pos, overStacking);
            this.set(COUNT, this.get(COUNT) + 1);
            if (!overStacking) {
                for (Objective objective : (Objective.ObjList)this.get(CHILDREN)) {
                    if (!(objective instanceof KillBossObjective)) continue;
                    KillBossObjective killBoss = (KillBossObjective)objective;
                    killBoss.set(KillBossObjective.BOSS_POS, pos);
                }
            }
            if (overStacking) {
                LootTableKey table = VaultRegistry.LOOT_TABLE.getKey(this.get(OVER_STACK_LOOT_TABLE));
                if (table == null) {
                    return;
                }
                LootTableGenerator generator = new LootTableGenerator(vault.get(Vault.VERSION), table, 0.0f);
                ChunkRandom random = ChunkRandom.any();
                random.setBlockSeed(vault.get(Vault.SEED), data.getPos(), 900397371L);
                generator.generate(random);
                ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
                generator.getItems().forEachRemaining(loot::add);
                for (int i = 0; i < loot.size(); ++i) {
                    ItemStack stack2 = (ItemStack)loot.get(i);
                    VaultLevelItem.doInitializeVaultLoot(stack2, vault, null);
                    stack2 = DataTransferItem.doConvertStack(stack2);
                    DataInitializationItem.doInitialize(stack2);
                    loot.set(i, stack2);
                }
                loot.removeIf(ItemStack::m_41619_);
                loot.forEach(stack -> Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)stack));
                data.setResult(InteractionResult.SUCCESS);
            }
            if ((patt9339$temp = data.getWorld().m_7702_(pos)) instanceof MonolithTileEntity && !(tile = (MonolithTileEntity)patt9339$temp).getModifiers().isEmpty()) {
                Iterator<Map.Entry<ResourceLocation, Integer>> it = tile.getModifiers().entrySet().iterator();
                TextComponent suffix = new TextComponent("");
                while (it.hasNext()) {
                    Map.Entry<ResourceLocation, Integer> entry = it.next();
                    Object modifier2 = VaultModifierRegistry.get(entry.getKey());
                    suffix.m_7220_(((VaultModifier)modifier2).getChatDisplayNameComponent(entry.getValue()));
                    if (!it.hasNext()) continue;
                    suffix.m_7220_((Component)new TextComponent(", "));
                }
                TextComponent text = new TextComponent("");
                if (!tile.getModifiers().isEmpty()) {
                    text.m_7220_(data.getPlayer().m_5446_()).m_7220_((Component)new TextComponent(" added ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)suffix).m_7220_((Component)new TextComponent(".").m_130940_(ChatFormatting.GRAY));
                }
                ChunkRandom random = ChunkRandom.any();
                random.setBlockSeed(vault.get(Vault.SEED), data.getPos(), 90039737L);
                tile.getModifiers().forEach((modifier, count) -> vault.get(Vault.MODIFIERS).addModifier((VaultModifier<?>)VaultModifierRegistry.get(modifier), (int)count, true, random));
                for (Listener listener : vault.get(Vault.LISTENERS).getAll()) {
                    listener.getPlayer().ifPresent(other -> {
                        world.m_6263_(null, other.m_20185_(), other.m_20186_(), other.m_20189_(), SoundEvents.f_12210_, SoundSource.PLAYERS, 0.9f, 1.2f);
                        other.m_5661_((Component)text, false);
                    });
                }
            }
            data.setResult(InteractionResult.SUCCESS);
        });
        CommonEvents.BLOCK_SET.at(BlockSetEvent.Type.RETURN).in((LevelWriter)world).register(this, data -> {
            PartialTile target = PartialTile.of(PartialBlockState.of(ModBlocks.PLACEHOLDER), PartialCompoundNbt.empty());
            target.getState().set(PlaceholderBlock.TYPE, PlaceholderBlock.Type.OBJECTIVE);
            if (target.isSubsetOf(PartialTile.of(data.getState()))) {
                data.getWorld().m_7731_(data.getPos(), ModBlocks.MONOLITH.m_49966_(), 3);
            }
        });
        CommonEvents.MONOLITH_UPDATE.register(this, data -> {
            ResourceLocation pool;
            if (data.getWorld() != world) {
                return;
            }
            if (data.getEntity().isGenerated() && (data.getEntity().isOverStacking() == this.get(COUNT) >= this.get(TARGET) || data.getState().m_61143_(MonolithBlock.STATE) != MonolithBlock.State.EXTINGUISHED)) {
                return;
            }
            data.getEntity().setOverStacking(this.get(COUNT) >= this.get(TARGET));
            if (data.getEntity().isOverStacking()) {
                data.getEntity().removeModifiers();
            }
            ResourceLocation resourceLocation = pool = data.getEntity().isOverStacking() ? this.get(OVER_STACK_MODIFIER_POOL) : this.get(STACK_MODIFIER_POOL);
            if (pool != null) {
                int level = vault.get(Vault.LEVEL).getOr(VaultLevel.VALUE, 0);
                ChunkRandom random = ChunkRandom.any();
                random.setBlockSeed(vault.get(Vault.SEED), data.getPos(), 90039737L);
                for (VaultModifier<?> modifier : ModConfigs.VAULT_MODIFIER_POOLS.getRandom(pool, level, random)) {
                    data.getEntity().addModifier(modifier);
                }
            }
            data.getEntity().setGenerated(true);
        });
        super.initServer(world, vault);
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault) {
        double increase = CommonEvents.OBJECTIVE_TARGET.invoke(world, vault, 0.0).getIncrease();
        this.set(TARGET, (int)Math.round((double)this.get(BASE_TARGET).intValue() * (1.0 + increase)));
        if (this.get(COUNT) >= this.get(TARGET)) {
            super.tickServer(world, vault);
        }
    }

    @Override
    public void tickListener(VirtualWorld world, Vault vault, Listener listener) {
        if (listener.getPriority(this) < 0) {
            listener.addObjective(vault, this);
        }
        if (listener instanceof Runner && this.get(COUNT) >= this.get(TARGET)) {
            super.tickListener(world, vault, listener);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean render(Vault vault, PoseStack matrixStack, Window window, float partialTicks, Player player) {
        if (this.get(COUNT) >= this.get(TARGET)) {
            int midX = window.m_85445_() / 2;
            Font font = Minecraft.m_91087_().f_91062_;
            MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            MutableComponent txt = new TextComponent("Pillage, or Exit to Complete").m_130940_(ChatFormatting.WHITE);
            FormattedCharSequence formattedCharSequence = txt.m_7532_();
            float f = (float)midX - (float)font.m_92852_((FormattedText)txt) / 2.0f;
            Objects.requireNonNull(font);
            font.m_92733_(formattedCharSequence, f, 9.0f, -1, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
            buffer.m_109911_();
            return true;
        }
        int current = this.get(COUNT);
        int total = this.get(TARGET);
        MutableComponent txt = new TextComponent(String.valueOf(current)).m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent(" / ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)new TextComponent(String.valueOf(total)).m_130940_(ChatFormatting.WHITE));
        int midX = window.m_85445_() / 2;
        matrixStack.m_85836_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int previousTexture = RenderSystem.m_157203_((int)0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)HUD);
        float progress = (float)current / (float)total;
        matrixStack.m_85837_((double)(midX - 80), 8.0, 0.0);
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)200, (int)26, (int)200, (int)100);
        GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)8, (float)0.0f, (float)30.0f, (int)(13 + (int)(130.0f * progress)), (int)10, (int)200, (int)100);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157453_((int)0, (int)previousTexture);
        matrixStack.m_85849_();
        Font font = Minecraft.m_91087_().f_91062_;
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.6f, 0.6f, 0.6f);
        FormattedCharSequence formattedCharSequence = txt.m_7532_();
        float f = (float)midX / 0.6f - (float)font.m_92852_((FormattedText)txt) / 2.0f;
        Objects.requireNonNull(font);
        font.m_92733_(formattedCharSequence, f, (float)(9 + 22), -1, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, 0, LightmapHelper.getPackedFullbrightCoords());
        buffer.m_109911_();
        matrixStack.m_85849_();
        return true;
    }

    @Override
    public boolean isActive(Vault vault, Objective objective) {
        if (this.get(COUNT) < this.get(TARGET)) {
            return objective == this;
        }
        for (Objective child : (Objective.ObjList)this.get(CHILDREN)) {
            if (!child.isActive(vault, objective)) continue;
            return true;
        }
        return false;
    }

    protected void playActivationEffects(VirtualWorld world, BlockPos pos, boolean overStacking) {
        if (overStacking) {
            BlockParticleOption particle = new BlockParticleOption(ParticleTypes.f_123794_, world.m_8055_(pos));
            Vec3 vec3 = new Vec3((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f));
            world.m_8767_((ParticleOptions)particle, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 400, 1.0, 1.0, 1.0, 0.5);
            world.m_8767_((ParticleOptions)ParticleTypes.f_175831_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 50, 1.0, 1.0, 1.0, 0.5);
            world.m_6263_(null, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, ModSounds.DESTROY_MONOLITH, SoundSource.PLAYERS, 0.25f, 1.0f);
        } else {
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new MonolithIgniteMessage(pos));
            world.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

