/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.block.ObeliskBlock;
import iskallia.vault.block.PlaceholderBlock;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.compound.UUIDList;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.BlockSetEvent;
import iskallia.vault.core.event.common.BlockUseEvent;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.LegacyObeliskObjective;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.overlay.VaultOverlay;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.tile.PartialBlockState;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.entity.entity.VaultGuardianEntity;
import iskallia.vault.entity.entity.guardian.GuardianType;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEntities;
import java.util.Arrays;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ObeliskObjective
extends Objective {
    public static final SupplierKey<Objective> KEY = (SupplierKey)((SupplierKey)SupplierKey.of("obelisk", Objective.class).with(Version.v1_0, (Objective)((Object)((Supplier<Objective>)LegacyObeliskObjective::new)))).with(Version.v1_6, ObeliskObjective::new);
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<Wave[]> WAVES = (FieldKey)FieldKey.of("waves", Wave[].class).with(Version.v1_6, Adapters.ofArray(Wave[]::new, CompoundAdapter.of(Wave::new)), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Float> OBJECTIVE_PROBABILITY = (FieldKey)FieldKey.of("objective_probability", Float.class).with(Version.v1_6, Adapters.FLOAT, DISK.all()).register(FIELDS);

    protected ObeliskObjective() {
    }

    protected ObeliskObjective(int target, IntSupplier wave, float objectiveProbability) {
        this.set(WAVES, new Wave[target]);
        for (int i = 0; i < this.get(WAVES).length; ++i) {
            this.get(ObeliskObjective.WAVES)[i] = new Wave(wave.getAsInt());
        }
        this.set(OBJECTIVE_PROBABILITY, Float.valueOf(objectiveProbability));
    }

    public static ObeliskObjective of(int target, IntSupplier wave, float objectiveProbability) {
        return new ObeliskObjective(target, wave, objectiveProbability);
    }

    @Override
    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    public boolean hasObelisksLeft() {
        for (Wave wave : this.get(WAVES)) {
            if (wave.isActive()) continue;
            return true;
        }
        return false;
    }

    public boolean isCompleted() {
        for (Wave wave : this.get(WAVES)) {
            if (wave.isCompleted()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.OBJECTIVE_PIECE_GENERATION.register(this, data -> this.ifPresent(OBJECTIVE_PROBABILITY, probability -> data.setProbability(probability.floatValue())));
        CommonEvents.BLOCK_USE.in((Level)world).at(BlockUseEvent.Phase.HEAD).of(ModBlocks.OBELISK).register(this, data -> {
            if (data.getHand() != InteractionHand.MAIN_HAND) {
                data.setResult(InteractionResult.SUCCESS);
                return;
            }
            if (!this.hasObelisksLeft()) {
                return;
            }
            BlockPos pos = data.getPos();
            if (((Boolean)data.getState().m_61143_((Property)ObeliskBlock.FILLED)).booleanValue()) {
                data.setResult(InteractionResult.SUCCESS);
                return;
            }
            if (data.getState().m_61143_(ObeliskBlock.HALF) == DoubleBlockHalf.UPPER && world.m_8055_(pos = pos.m_7495_()).m_60734_() != ModBlocks.OBELISK) {
                data.setResult(InteractionResult.SUCCESS);
                return;
            }
            if (vault.get(Vault.LISTENERS).getObjectivePriority(data.getPlayer().m_142081_(), this) != 0) {
                data.setResult(InteractionResult.SUCCESS);
                return;
            }
            world.m_7731_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)ObeliskBlock.FILLED, (Comparable)Boolean.valueOf(true)), 3);
            world.m_7731_(pos.m_7494_(), (BlockState)world.m_8055_(pos.m_7494_()).m_61124_((Property)ObeliskBlock.FILLED, (Comparable)Boolean.valueOf(true)), 3);
            this.onObeliskActivated(world, vault, pos);
            data.setResult(InteractionResult.SUCCESS);
        });
        CommonEvents.BLOCK_SET.at(BlockSetEvent.Type.RETURN).in((LevelWriter)world).register(this, data -> {
            PartialTile target = PartialTile.of(PartialBlockState.of(ModBlocks.PLACEHOLDER), PartialCompoundNbt.empty());
            target.getState().set(PlaceholderBlock.TYPE, PlaceholderBlock.Type.OBJECTIVE);
            if (target.isSubsetOf(PartialTile.of(data.getState()))) {
                BlockState lower = (BlockState)((BlockState)ModBlocks.OBELISK.m_49966_().m_61124_(ObeliskBlock.HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)ObeliskBlock.FILLED, (Comparable)Boolean.valueOf(false));
                BlockState upper = (BlockState)((BlockState)ModBlocks.OBELISK.m_49966_().m_61124_(ObeliskBlock.HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)ObeliskBlock.FILLED, (Comparable)Boolean.valueOf(false));
                data.getWorld().m_7731_(data.getPos(), lower, 3);
                data.getWorld().m_7731_(data.getPos().m_7494_(), upper, 3);
            }
        });
        CommonEvents.ENTITY_DEATH.register(this, event -> {
            if (event.getEntity().f_19853_ != world) {
                return;
            }
            for (Wave wave : this.get(WAVES)) {
                if (!wave.get(Wave.MOBS).remove(event.getEntity().m_142081_())) continue;
                wave.modify(Wave.COUNT, x -> x + 1);
            }
        });
        super.initServer(world, vault);
    }

    private void onObeliskActivated(VirtualWorld world, Vault vault, BlockPos pos) {
        this.playActivationEffects(world, pos);
        Wave wave = Arrays.stream(this.get(WAVES)).filter(w -> !w.has(Wave.ACTIVE)).findFirst().orElseThrow();
        wave.set(Wave.ACTIVE);
        JavaRandom random = JavaRandom.ofNanoTime();
        for (int i = 0; i < wave.get(Wave.TARGET); ++i) {
            wave.get(Wave.MOBS).add(this.doSpawn(world, vault, pos, random).m_142081_());
        }
    }

    public LivingEntity doSpawn(VirtualWorld world, Vault vault, BlockPos pos, RandomSource random) {
        double min = 10.0;
        double max = 13.0;
        LivingEntity spawned = null;
        while (spawned == null) {
            double angle = Math.PI * 2 * random.nextDouble();
            double distance = Math.sqrt(random.nextDouble() * (max * max - min * min) + min * min);
            int x = (int)Math.ceil(distance * Math.cos(angle));
            int z = (int)Math.ceil(distance * Math.sin(angle));
            double xzRadius = Math.sqrt(x * x + z * z);
            double yRange = Math.sqrt(max * max - xzRadius * xzRadius);
            int y = random.nextInt((int)Math.ceil(yRange) * 2 + 1) - (int)Math.ceil(yRange);
            spawned = ObeliskObjective.spawnMob(world, vault, pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z, random);
        }
        return spawned;
    }

    @Nullable
    public static LivingEntity spawnMob(VirtualWorld world, Vault vault, int x, int y, int z, RandomSource random) {
        GuardianType type = ModConfigs.VAULT_GUARDIAN.getType(vault.get(Vault.LEVEL).get(), random);
        VaultGuardianEntity entity = null;
        if (type == GuardianType.BRUISER) {
            entity = (VaultGuardianEntity)ModEntities.BRUISER_GUARDIAN.m_20615_((Level)world);
        } else if (type == GuardianType.ARBALIST) {
            entity = (VaultGuardianEntity)ModEntities.ARBALIST_GUARDIAN.m_20615_((Level)world);
        }
        entity.setType(type);
        entity.m_146915_(true);
        BlockState state = world.m_8055_(new BlockPos(x, y - 1, z));
        if (!state.m_60643_((BlockGetter)world, new BlockPos(x, y - 1, z), entity.m_6095_())) {
            return null;
        }
        AABB entityBox = entity.m_6095_().m_20585_((double)x + 0.5, (double)y, (double)z + 0.5);
        if (!world.m_45772_(entityBox)) {
            return null;
        }
        entity.m_7678_((float)x + 0.5f, (float)y + 0.2f, (float)z + 0.5f, (float)(random.nextDouble() * 2.0 * Math.PI), 0.0f);
        entity.m_21373_();
        entity.m_6518_((ServerLevelAccessor)world, new DifficultyInstance(Difficulty.PEACEFUL, 13000L, 0L, 0.0f), MobSpawnType.STRUCTURE, null, null);
        world.m_8847_((Entity)entity);
        return entity;
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault) {
        if (this.isCompleted()) {
            super.tickServer(world, vault);
        }
    }

    @Override
    public void tickListener(VirtualWorld world, Vault vault, Listener listener) {
        if (listener.getPriority(this) < 0) {
            listener.addObjective(vault, this);
        }
        if (listener instanceof Runner && this.isCompleted()) {
            super.tickListener(world, vault, listener);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean render(Vault vault, PoseStack matrixStack, Window window, float partialTicks, Player player) {
        if (this.isCompleted()) {
            boolean rendered = false;
            for (Objective objective : (Objective.ObjList)this.get(CHILDREN)) {
                rendered |= objective.render(vault, matrixStack, window, partialTicks, player);
            }
            if (rendered) {
                return true;
            }
        }
        int midX = window.m_85445_() / 2;
        int gapWidth = 7;
        int itemBoxWidth = 22;
        int iconWidth = 12;
        int iconHeight = 22;
        Wave[] waves = this.get(WAVES);
        int totalWidth = waves.length * itemBoxWidth + (waves.length - 1) * gapWidth;
        int shiftX = -totalWidth / 2;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)((float)midX + (float)shiftX * 0.7f), 17.0, 0.0);
        matrixStack.m_85841_(0.7f, 0.7f, 0.7f);
        for (Wave wave : waves) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, (double)((float)(-itemBoxWidth) / 2.0f), 0.0);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int previousTexture = RenderSystem.m_157203_((int)0);
            RenderSystem.m_157456_((int)0, (ResourceLocation)VaultOverlay.VAULT_HUD);
            if (wave.isActive()) {
                GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)77.0f, (float)84.0f, (int)iconWidth, (int)iconHeight, (int)256, (int)256);
            } else {
                GuiComponent.m_93133_((PoseStack)matrixStack, (int)0, (int)0, (float)64.0f, (float)84.0f, (int)iconWidth, (int)iconHeight, (int)256, (int)256);
            }
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157453_((int)0, (int)previousTexture);
            matrixStack.m_85837_(6.0, 24.0, 0.0);
            String requiredText = wave.get(Wave.COUNT) + "/" + wave.get(Wave.TARGET);
            TextComponent cmp = new TextComponent(requiredText);
            cmp = wave.isCompleted() ? cmp.m_130940_(ChatFormatting.GREEN) : (wave.isActive() ? cmp.m_130940_(ChatFormatting.RED) : cmp.m_6270_(Style.f_131099_.m_178520_(0xD4D4D4)));
            UIHelper.renderCenteredWrappedText(matrixStack, (Component)cmp, 30, 0);
            matrixStack.m_85849_();
            matrixStack.m_85837_((double)(itemBoxWidth + gapWidth), 0.0, 0.0);
        }
        matrixStack.m_85849_();
        return true;
    }

    @Override
    public boolean isActive(Vault vault, Objective objective) {
        if (!this.isCompleted()) {
            return objective == this;
        }
        for (Objective child : (Objective.ObjList)this.get(CHILDREN)) {
            if (!child.isActive(vault, objective)) continue;
            return true;
        }
        return false;
    }

    protected void playActivationEffects(VirtualWorld world, BlockPos pos) {
        for (int i = 0; i < 20; ++i) {
            double d0 = world.f_46441_.nextGaussian() * 0.02;
            double d1 = world.f_46441_.nextGaussian() * 0.02;
            double d2 = world.f_46441_.nextGaussian() * 0.02;
            world.m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_() + world.f_46441_.nextDouble() - d0, (double)pos.m_123342_() + world.f_46441_.nextDouble() - d1, (double)pos.m_123343_() + world.f_46441_.nextDouble() - d2, 10, d0, d1, d2, 1.0);
        }
        world.m_5594_(null, pos, SoundEvents.f_11767_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public static class Wave
    extends DataObject<Wave> {
        public static final FieldRegistry FIELDS = new FieldRegistry();
        public static final FieldKey<Integer> COUNT = (FieldKey)FieldKey.of("count", Integer.class).with(Version.v1_6, Adapters.INT_SEGMENTED_3, DISK.all().or(CLIENT.all())).register(FIELDS);
        public static final FieldKey<Integer> TARGET = (FieldKey)FieldKey.of("target", Integer.class).with(Version.v1_6, Adapters.INT_SEGMENTED_3, DISK.all().or(CLIENT.all())).register(FIELDS);
        public static final FieldKey<Void> ACTIVE = (FieldKey)FieldKey.of("active", Void.class).with(Version.v1_6, Adapters.ofVoid(), DISK.all().or(CLIENT.all())).register(FIELDS);
        public static final FieldKey<UUIDList> MOBS = (FieldKey)FieldKey.of("mobs", UUIDList.class).with(Version.v1_6, CompoundAdapter.of(UUIDList::create), DISK.all().or(CLIENT.all())).register(FIELDS);

        public Wave() {
        }

        public Wave(int target) {
            this.set(COUNT, 0);
            this.set(TARGET, target);
            this.set(MOBS, UUIDList.create());
        }

        @Override
        public FieldRegistry getFields() {
            return FIELDS;
        }

        public boolean isActive() {
            return this.has(ACTIVE);
        }

        public boolean isCompleted() {
            return this.get(COUNT) >= this.get(TARGET);
        }
    }
}

