/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.block.PlaceholderBlock;
import iskallia.vault.block.entity.GateLockTileEntity;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.core.vault.modifier.VaultModifierStack;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.VaultGenerator;
import iskallia.vault.core.world.generator.layout.ClassicPresetLayout;
import iskallia.vault.core.world.generator.layout.GridLayout;
import iskallia.vault.core.world.loot.generator.LootGenerator;
import iskallia.vault.core.world.loot.generator.LootTableGenerator;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.item.GodBlessingItem;
import iskallia.vault.item.KeystoneItem;
import iskallia.vault.item.crystal.layout.preset.ParadoxTemplatePreset;
import iskallia.vault.item.crystal.layout.preset.PoolTemplatePreset;
import iskallia.vault.item.crystal.layout.preset.TemplatePreset;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.world.data.ParadoxCrystalData;
import iskallia.vault.world.data.PlayerReputationData;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ParadoxObjective
extends Objective {
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of("divine_paradox", Objective.class).with(Version.v1_19, (Objective)((Object)((Supplier<Objective>)() -> new ParadoxObjective())));
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<Type> TYPE = (FieldKey)FieldKey.of("type", Type.class).with(Version.v1_19, Adapters.ofEnum(Type.class, EnumAdapter.Mode.ORDINAL), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<UUID> PLAYER = (FieldKey)FieldKey.of("player", UUID.class).with(Version.v1_19, Adapters.UUID, DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Long> SEED = (FieldKey)FieldKey.of("seed", Long.class).with(Version.v1_19, Adapters.LONG, DISK.all().or(CLIENT.all())).register(FIELDS);

    protected ParadoxObjective() {
    }

    protected ParadoxObjective(Type type, UUID player, long seed) {
        this.set(TYPE, type);
        this.set(PLAYER, player);
        this.set(SEED, seed);
    }

    public static ParadoxObjective of(Type type, UUID player, long seed) {
        return new ParadoxObjective(type, player, seed);
    }

    @Override
    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.OBJECTIVE_PIECE_GENERATION.register(this, data -> data.setProbability(0.0));
        CommonEvents.LOOT_GENERATION.register(this, data -> {
            if (this.get(TYPE) != Type.BUILD) {
                return;
            }
            LootGenerator patt3915$temp = data.getGenerator();
            if (patt3915$temp instanceof LootTableGenerator) {
                LootTableGenerator generator = (LootTableGenerator)patt3915$temp;
                Entity patt3996$temp = generator.source;
                if (!(patt3996$temp instanceof ServerPlayer)) {
                    return;
                }
                ServerPlayer player = (ServerPlayer)patt3996$temp;
                if (player.f_19853_ != world) {
                    return;
                }
                generator.setItems(new ArrayList<ItemStack>());
            }
        });
        CommonEvents.PLACEHOLDER_PROCESSING.register(this, data -> {
            if (data.getContext().getVault() != vault) {
                return;
            }
            if (data.getTile().getState().get(PlaceholderBlock.TYPE) != PlaceholderBlock.Type.GATE) {
                return;
            }
            Direction direction = ((Direction)data.getTile().getState().get(PlaceholderBlock.FACING)).m_122424_();
            VaultGenerator generator = vault.get(Vault.WORLD).get(WorldManager.GENERATOR);
            if (generator instanceof GridGenerator) {
                GridGenerator gridGenerator = (GridGenerator)generator;
                ChunkRandom random = ChunkRandom.any();
                RegionPos region = RegionPos.ofBlockPos(data.getTile().getPos(), gridGenerator.get(GridGenerator.CELL_X), gridGenerator.get(GridGenerator.CELL_Z)).add(direction, 2);
                random.setRegionSeed(this.get(PLAYER).getMostSignificantBits(), region.m_123341_(), region.m_123343_(), this.get(SEED));
                data.getContext().setRandom(data.getTile().getPos(), random);
            }
        });
        CommonEvents.GATE_LOCK_UPDATE.register(this, data -> {
            if (data.getLevel() != world) {
                return;
            }
            Direction direction = data.getEntity().getDirection().m_122424_();
            VaultGenerator generator = vault.get(Vault.WORLD).get(WorldManager.GENERATOR);
            if (generator instanceof GridGenerator) {
                GridGenerator gridGenerator = (GridGenerator)generator;
                RegionPos region = RegionPos.ofBlockPos(data.getPos(), gridGenerator.get(GridGenerator.CELL_X), gridGenerator.get(GridGenerator.CELL_Z));
                GridLayout layout = gridGenerator.get(GridGenerator.LAYOUT);
                if (layout instanceof ClassicPresetLayout) {
                    ClassicPresetLayout presetLayout = (ClassicPresetLayout)layout;
                    boolean hasTunnel = presetLayout.hasGenerated(region.add(direction, 1));
                    boolean hasRoom = presetLayout.hasGenerated(region.add(direction, 2));
                    GateLockTileEntity.State state = data.getEntity().getState();
                    ChunkRandom random = ChunkRandom.any();
                    random.setBlockSeed(this.get(PLAYER).getMostSignificantBits(), data.getPos(), this.get(SEED));
                    int count = (int)presetLayout.get(ClassicPresetLayout.PRESET).getAll().values().stream().filter(templatePreset -> {
                        if (!(templatePreset instanceof ParadoxTemplatePreset)) {
                            return false;
                        }
                        ParadoxTemplatePreset paradoxTemplatePreset = (ParadoxTemplatePreset)templatePreset;
                        return paradoxTemplatePreset.getGod() == data.getEntity().getGod();
                    }).count() + 1;
                    data.getEntity().setReputationCost(count);
                    if (!hasTunnel && !hasRoom) {
                        if (state != GateLockTileEntity.State.TUNNEL_AND_ROOM) {
                            data.getEntity().setState(GateLockTileEntity.State.TUNNEL_AND_ROOM);
                            data.getEntity().generateCostAndModifiers(random);
                        }
                    } else if (!hasTunnel) {
                        if (state != GateLockTileEntity.State.TUNNEL) {
                            data.getEntity().setState(GateLockTileEntity.State.TUNNEL);
                            data.getEntity().generateCostAndModifiers(random);
                        }
                    } else {
                        data.getEntity().setStep(GateLockTileEntity.Step.REMOVED);
                    }
                    if (state == GateLockTileEntity.State.TUNNEL_AND_ROOM) {
                        data.getEntity().setReputationCost(count);
                    } else if (state == GateLockTileEntity.State.TUNNEL) {
                        data.getEntity().setReputationCost(0);
                    }
                }
            }
        });
        CommonEvents.GATE_LOCK_OPEN.register(this, data -> {
            if (data.getWorld() != world || this.get(TYPE) == Type.RUN) {
                return;
            }
            if (!InventoryUtil.consumeInputs(data.getEntity().getCost(), data.getPlayer().m_150109_(), true)) {
                return;
            }
            if (PlayerReputationData.getReputation(data.getPlayer().m_142081_(), data.getEntity().getGod()) < data.getEntity().getReputationCost()) {
                return;
            }
            InventoryUtil.consumeInputs(data.getEntity().getCost(), data.getPlayer().m_150109_(), false);
            Direction direction = data.getEntity().getDirection().m_122424_();
            VaultGenerator generator = vault.get(Vault.WORLD).get(WorldManager.GENERATOR);
            if (generator instanceof GridGenerator) {
                GridGenerator gridGenerator = (GridGenerator)generator;
                RegionPos region = RegionPos.ofBlockPos(data.getPos(), gridGenerator.get(GridGenerator.CELL_X), gridGenerator.get(GridGenerator.CELL_Z));
                GridLayout layout = gridGenerator.get(GridGenerator.LAYOUT);
                if (layout instanceof ClassicPresetLayout) {
                    ClassicPresetLayout presetLayout = (ClassicPresetLayout)layout;
                    boolean changed = false;
                    if (!presetLayout.hasGenerated(region.add(direction, 1))) {
                        presetLayout.append(vault, (ServerLevelAccessor)world, region.add(direction, 1), new PoolTemplatePreset(data.getEntity().getTunnel()));
                        changed = true;
                    }
                    if (!presetLayout.hasGenerated(region.add(direction, 2))) {
                        presetLayout.append(vault, (ServerLevelAccessor)world, region.add(direction, 2), new ParadoxTemplatePreset(data.getEntity().getRoom(), data.getEntity().getGod()));
                        changed = true;
                    }
                    if (changed) {
                        ParadoxCrystalData.Entry entry = ParadoxCrystalData.get(world).getOrCreate(this.get(PLAYER));
                        entry.preset = presetLayout.get(ClassicPresetLayout.PRESET);
                        entry.mergeModifiers(data.getEntity().getModifiers());
                        ChunkRandom random = ChunkRandom.any();
                        random.setBlockSeed(this.get(PLAYER).getLeastSignificantBits(), data.getPos(), this.get(SEED));
                        for (VaultModifierStack modifier : data.getEntity().getModifiers()) {
                            vault.get(Vault.MODIFIERS).addModifier(modifier.getModifier(), modifier.getSize(), true, random);
                        }
                        entry.changed = true;
                    }
                }
            }
            data.getEntity().setStep(GateLockTileEntity.Step.REMOVED);
            world.m_6263_(null, data.getPos().m_123341_(), data.getPos().m_123342_(), data.getPos().m_123343_(), SoundEvents.f_12210_, SoundSource.PLAYERS, 0.9f, 1.2f);
        });
        CommonEvents.ITEM_SCAVENGE_TASK.register(this, data -> {
            if (data.getWorld() != world) {
                return;
            }
            VaultGod god = this.getGod(vault, data.getPos());
            if (god == null) {
                return;
            }
            data.getItems().removeIf(stack -> {
                KeystoneItem keystone;
                Item patt10905$temp = stack.m_41720_();
                return patt10905$temp instanceof KeystoneItem && (keystone = (KeystoneItem)patt10905$temp).getGod() != god;
            });
            data.getItems().removeIf(stack -> stack.m_41720_() instanceof GodBlessingItem && GodBlessingItem.getGod(stack) != god);
        });
        super.initServer(world, vault);
    }

    private VaultGod getGod(Vault vault, BlockPos pos) {
        VaultGenerator generator = vault.get(Vault.WORLD).get(WorldManager.GENERATOR);
        if (generator instanceof GridGenerator) {
            GridGenerator gridGenerator = (GridGenerator)generator;
            RegionPos region = RegionPos.ofBlockPos(pos, gridGenerator.get(GridGenerator.CELL_X), gridGenerator.get(GridGenerator.CELL_Z));
            GridLayout layout = gridGenerator.get(GridGenerator.LAYOUT);
            if (layout instanceof ClassicPresetLayout) {
                ClassicPresetLayout presetLayout = (ClassicPresetLayout)layout;
                TemplatePreset preset = presetLayout.get(ClassicPresetLayout.PRESET).get(region).orElse(null);
                if (!(preset instanceof ParadoxTemplatePreset)) {
                    return null;
                }
                ParadoxTemplatePreset paradoxPreset = (ParadoxTemplatePreset)preset;
                return paradoxPreset.getGod();
            }
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean render(Vault vault, PoseStack matrixStack, Window window, float partialTicks, Player player) {
        boolean rendered = false;
        for (Objective objective : (Objective.ObjList)this.get(CHILDREN)) {
            rendered |= objective.render(vault, matrixStack, window, partialTicks, player);
        }
        return rendered;
    }

    @Override
    public boolean isActive(Vault vault, Objective objective) {
        return objective == this;
    }

    public static enum Type {
        BUILD("Build"),
        RUN("Run");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

