/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.block.DivineAltarBlock;
import iskallia.vault.block.PlaceholderBlock;
import iskallia.vault.client.gui.helper.FontHelper;
import iskallia.vault.client.gui.helper.ScreenDrawHelper;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.client.util.ClientScheduler;
import iskallia.vault.config.ScavengerConfig;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.DataMap;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.data.adapter.vault.CompoundAdapter;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.BlockSetEvent;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.objective.scavenger.ScavengeTask;
import iskallia.vault.core.vault.objective.scavenger.ScavengerGoal;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.tile.PartialBlockState;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.GodBlessingItem;
import iskallia.vault.item.KeystoneItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.RenderProperties;

public class ScavengerObjective
extends Objective {
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of("scavenger", Objective.class).with(Version.v1_0, (Objective)((Object)((Supplier<Objective>)ScavengerObjective::new)));
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<GoalMap> GOALS = (FieldKey)FieldKey.of("goals", GoalMap.class).with(Version.v1_0, CompoundAdapter.of(GoalMap::new), DISK.all().or(CLIENT.all())).register(FIELDS);
    public static final FieldKey<Float> OBJECTIVE_PROBABILITY = (FieldKey)FieldKey.of("objective_probability", Float.class).with(Version.v1_2, Adapters.FLOAT, DISK.all()).register(FIELDS);
    public static final FieldKey<Config> CONFIG = (FieldKey)FieldKey.of("config", Config.class).with(Version.v1_19, Adapters.ofEnum(Config.class, EnumAdapter.Mode.ORDINAL), DISK.all()).register(FIELDS);

    protected ScavengerObjective() {
        this.set(GOALS, new GoalMap());
    }

    protected ScavengerObjective(float objectiveProbability, Config config) {
        this.set(GOALS, new GoalMap());
        this.set(OBJECTIVE_PROBABILITY, Float.valueOf(objectiveProbability));
        this.set(CONFIG, config);
    }

    public static ScavengerObjective of(float objectiveProbability, Config config) {
        return new ScavengerObjective(objectiveProbability, config);
    }

    @Override
    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.OBJECTIVE_PIECE_GENERATION.register(this, data -> this.ifPresent(OBJECTIVE_PROBABILITY, probability -> data.setProbability(probability.floatValue())));
        CommonEvents.BLOCK_SET.at(BlockSetEvent.Type.RETURN).in((LevelWriter)world).register(this, data -> {
            PartialTile target = PartialTile.of(PartialBlockState.of(ModBlocks.PLACEHOLDER), PartialCompoundNbt.empty());
            target.getState().set(PlaceholderBlock.TYPE, PlaceholderBlock.Type.OBJECTIVE);
            if (target.isSubsetOf(PartialTile.of(data.getState()))) {
                data.getWorld().m_7731_(data.getPos(), ModBlocks.SCAVENGER_ALTAR.m_49966_(), 3);
            }
        });
        CommonEvents.SCAVENGER_ALTAR_CONSUME.register(this, data -> {
            if (data.getLevel() != world || data.getTile().getItemPlacedBy() == null) {
                return;
            }
            Listener listener = vault.get(Vault.LISTENERS).get(data.getTile().getItemPlacedBy());
            if (!(listener instanceof Runner)) {
                return;
            }
            BlockState state = data.getTile().m_58900_();
            if (state.m_60734_() == ModBlocks.DIVINE_ALTAR) {
                Item patt5959$temp = data.getTile().getHeldItem().m_41720_();
                if (patt5959$temp instanceof KeystoneItem) {
                    KeystoneItem keystone = (KeystoneItem)patt5959$temp;
                    if (keystone.getGod() != state.m_61143_(DivineAltarBlock.GOD)) {
                        return;
                    }
                } else if (data.getTile().getHeldItem().m_41720_() instanceof GodBlessingItem) {
                    if (GodBlessingItem.getGod(data.getTile().getHeldItem()) != state.m_61143_(DivineAltarBlock.GOD)) {
                        return;
                    }
                } else {
                    return;
                }
            }
            boolean creative = listener.getPlayer().map(ServerPlayer::m_7500_).orElse(false);
            CompoundTag nbt = data.getTile().getHeldItem().m_41783_();
            if (!(creative || nbt != null && nbt.m_128461_("VaultId").equals(vault.get(Vault.ID).toString()))) {
                return;
            }
            List goals = (List)this.get(GOALS).get(listener.get(Listener.ID));
            for (ScavengerGoal goal : goals) {
                goal.consume(data.getTile().getHeldItem());
            }
        });
        for (ScavengeTask task : this.getOr(CONFIG, Config.DEFAULT).get().getTasks()) {
            task.initServer(world, vault, this);
        }
        super.initServer(world, vault);
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault) {
        this.get(GOALS).forEach((uuid, goal) -> goal.forEach(task -> task.tick(world, vault)));
        if (this.get(GOALS).areAllCompleted(vault)) {
            super.tickServer(world, vault);
        }
    }

    @Override
    public void tickListener(VirtualWorld world, Vault vault, Listener listener) {
        ScavengerGoal.ObjList goal;
        if (listener instanceof Runner && listener.getPriority(this) < 0) {
            listener.addObjective(vault, this);
            this.generateGoal(vault, listener);
        }
        if ((goal = (ScavengerGoal.ObjList)this.get(GOALS).get(listener.get(Listener.ID))) != null && goal.areAllCompleted()) {
            super.tickListener(world, vault, listener);
        }
    }

    private void generateGoal(Vault vault, Listener listener) {
        ScavengerGoal.ObjList list = new ScavengerGoal.ObjList();
        this.get(GOALS).put(listener.get(Listener.ID), list);
        JavaRandom random = JavaRandom.ofInternal(vault.get(Vault.SEED) ^ listener.get(Listener.ID).getMostSignificantBits());
        list.addAll(this.getOr(CONFIG, Config.DEFAULT).get().generateGoals(vault.get(Vault.LEVEL).get(), random));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean render(Vault vault, PoseStack matrixStack, Window window, float partialTicks, Player player) {
        ScavengerGoal.ObjList goals = (ScavengerGoal.ObjList)this.get(GOALS).get(player.m_142081_());
        if (goals == null || goals.areAllCompleted()) {
            boolean rendered = false;
            for (Objective objective : (Objective.ObjList)this.get(CHILDREN)) {
                rendered |= objective.render(vault, matrixStack, window, partialTicks, player);
            }
            if (rendered) {
                return true;
            }
        }
        if (goals == null) {
            return true;
        }
        Minecraft mc = Minecraft.m_91087_();
        int tabListOffset = mc.f_91065_.m_93088_().f_94524_ ? mc.f_91074_.f_108617_.m_105142_().size() * 9 + 10 : 0;
        int totalX = 0;
        int totalY = tabListOffset;
        int midX = window.m_85445_() / 2;
        int gapWidth = 7;
        int itemBoxWidth = 32;
        ArrayList<ScavengerGoal> filteredGoals = new ArrayList<ScavengerGoal>(goals);
        filteredGoals.removeIf(ScavengerGoal::isCompleted);
        int totalWidth = filteredGoals.size() * itemBoxWidth + (filteredGoals.size() - 1) * gapWidth;
        int shiftX = -totalWidth / 2 + itemBoxWidth / 2;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        matrixStack.m_85836_();
        int yOffset = 0;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(midX + shiftX), (double)((float)itemBoxWidth * 0.75f), 0.0);
        totalX += midX + shiftX;
        totalY = (int)((double)totalY + (double)itemBoxWidth * 0.75);
        for (ScavengerGoal goal : filteredGoals) {
            int reqYOffset = ScavengerObjective.renderItemRequirement(matrixStack, goal, itemBoxWidth, totalX, totalY, partialTicks);
            if (reqYOffset > yOffset) {
                yOffset = reqYOffset;
            }
            matrixStack.m_85837_((double)(itemBoxWidth + gapWidth), 0.0, 0.0);
            totalX += itemBoxWidth + gapWidth;
        }
        matrixStack.m_85849_();
        matrixStack.m_85849_();
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static int renderItemRequirement(PoseStack matrixStack, ScavengerGoal goal, int itemBoxWidth, int totalX, int totalY, float partialTicks) {
        ArrayList entries = new ArrayList();
        goal.getEntries().forEachRemaining(entries::add);
        float time = (float)ClientScheduler.INSTANCE.getTickCount() + partialTicks;
        ScavengerGoal.Entry entry = (ScavengerGoal.Entry)entries.get((int)(time / 20.0f) % entries.size());
        ItemStack requiredStack = entry.getStack();
        ResourceLocation iconPath = entry.getIcon();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, (double)((float)(-itemBoxWidth) / 2.0f), 0.0);
        totalY = (int)((float)totalY + (float)(-itemBoxWidth) / 2.0f);
        ScavengerObjective.renderItemStack(matrixStack, requiredStack, totalX, totalY);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)iconPath);
        matrixStack.m_85836_();
        matrixStack.m_85837_(-16.0, -2.4, 0.0);
        matrixStack.m_85841_(0.4f, 0.4f, 1.0f);
        ScreenDrawHelper.drawTexturedQuads(buf -> ScreenDrawHelper.rect((VertexConsumer)buf, matrixStack).dim(16.0f, 16.0f).draw());
        matrixStack.m_85849_();
        matrixStack.m_85837_(0.0, 10.0, 0.0);
        String requiredText = goal.get(ScavengerGoal.CURRENT) + "/" + goal.get(ScavengerGoal.TOTAL);
        MutableComponent cmp = new TextComponent(requiredText).m_130940_(ChatFormatting.GREEN);
        UIHelper.renderCenteredWrappedText(matrixStack, (Component)cmp, 30, 0);
        matrixStack.m_85837_(0.0, 10.0, 0.0);
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.5f, 0.5f, 1.0f);
        Component name = requiredStack.m_41786_();
        MutableComponent display = name.m_6881_().m_130948_(Style.f_131099_.m_178520_(entry.getColor()));
        int lines = UIHelper.renderCenteredWrappedText(matrixStack, (Component)display, 60, 0);
        matrixStack.m_85849_();
        matrixStack.m_85849_();
        return 25 + lines * 5;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderItemStack(PoseStack renderStack, ItemStack item, int totalX, int totalY) {
        Minecraft mc = Minecraft.m_91087_();
        ItemRenderer ir = mc.m_91291_();
        Font fr = RenderProperties.get((ItemStack)item).getFont(item);
        if (fr == null) {
            fr = mc.f_91062_;
        }
        ir.f_115093_ = 200.0f;
        ir.m_115203_(item, totalX - 8, totalY - 8);
        ir.m_115174_(fr, item, totalX - 8, totalY - 8, null);
        ir.f_115093_ = 0.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderPartyInfo(PoseStack matrixStack, UUID playerUUID) {
        super.renderPartyInfo(matrixStack, playerUUID);
        ArrayList scavItems = new ArrayList();
        ScavengerGoal.ObjList scavengerGoals = (ScavengerGoal.ObjList)this.get(GOALS).get(playerUUID);
        if (scavengerGoals == null) {
            return;
        }
        ArrayList<ScavengerGoal> filteredGoals = new ArrayList<ScavengerGoal>(scavengerGoals);
        filteredGoals.removeIf(ScavengerGoal::isCompleted);
        filteredGoals.forEach(goal -> {
            ArrayList entries = new ArrayList();
            goal.getEntries().forEachRemaining(entries::add);
            float time = ClientScheduler.INSTANCE.getTickCount();
            ScavengerGoal.Entry entry = (ScavengerGoal.Entry)entries.get((int)(time / 20.0f) % entries.size());
            scavItems.add(entry.getStack(goal.get(ScavengerGoal.TOTAL) - goal.get(ScavengerGoal.CURRENT)));
        });
        if (!scavItems.isEmpty()) {
            matrixStack.m_85837_(-10.0 - (double)(scavItems.size() + 1) * 18.0, 3.0, 100.0);
            for (ItemStack stack : scavItems) {
                matrixStack.m_85836_();
                matrixStack.m_85841_(1.0f, -1.0f, 1.0f);
                matrixStack.m_85841_(16.0f, 16.0f, 16.0f);
                Minecraft minecraft = Minecraft.m_91087_();
                ItemRenderer itemRenderer = minecraft.m_91291_();
                BakedModel bakedModel = itemRenderer.m_174264_(stack, null, null, 0);
                if (!bakedModel.m_7547_()) {
                    Lighting.m_84930_();
                }
                MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
                itemRenderer.m_115143_(stack, ItemTransforms.TransformType.GUI, false, matrixStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, bakedModel);
                bufferSource.m_109911_();
                if (!bakedModel.m_7547_()) {
                    Lighting.m_84931_();
                }
                matrixStack.m_85849_();
                matrixStack.m_85836_();
                matrixStack.m_85837_(9.0, 0.0, 200.0);
                FontHelper.drawTextComponent(matrixStack, (Component)new TextComponent(String.valueOf(stack.m_41613_())), true);
                matrixStack.m_85849_();
                matrixStack.m_85837_(18.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean isActive(Vault vault, Objective objective) {
        if (!this.get(GOALS).areAllCompleted(vault)) {
            return objective == this;
        }
        for (Objective child : (Objective.ObjList)this.get(CHILDREN)) {
            if (!child.isActive(vault, objective)) continue;
            return true;
        }
        return false;
    }

    public static class GoalMap
    extends DataMap<GoalMap, UUID, ScavengerGoal.ObjList> {
        public GoalMap() {
            super(new HashMap(), Adapters.UUID, CompoundAdapter.of(ScavengerGoal.ObjList::new));
        }

        public boolean areAllCompleted(Vault vault) {
            for (Runner runner : vault.get(Vault.LISTENERS).getAll(Runner.class)) {
                if (!this.containsKey(runner.getId()) || ((ScavengerGoal.ObjList)this.get(runner.getId())).areAllCompleted()) continue;
                return false;
            }
            return true;
        }
    }

    public static enum Config {
        DEFAULT(() -> ModConfigs.SCAVENGER),
        DIVINE_PARADOX(() -> ModConfigs.DIVINE_PARADOX);

        private Supplier<ScavengerConfig> supplier;

        private Config(Supplier<ScavengerConfig> supplier) {
            this.supplier = supplier;
        }

        public ScavengerConfig get() {
            return this.supplier.get();
        }
    }
}

