/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.KillBossObjective;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.player.ClassicListenersLogic;
import iskallia.vault.core.vault.player.Completion;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.init.ModEntities;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.function.Supplier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TrackSpeedrunObjective
extends Objective {
    public static final SupplierKey<Objective> KEY = (SupplierKey)SupplierKey.of("track_speedrun", Objective.class).with(Version.v1_0, (Objective)((Object)((Supplier<Objective>)TrackSpeedrunObjective::new)));
    public static final FieldRegistry FIELDS = Objective.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<Void> INITIALIZED = (FieldKey)FieldKey.of("initialized", Void.class).with(Version.v1_0, Adapters.ofVoid(), DISK.all()).register(FIELDS);

    public static TrackSpeedrunObjective create() {
        TrackSpeedrunObjective objective = new TrackSpeedrunObjective();
        return objective;
    }

    @Override
    public SupplierKey<Objective> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault) {
        CommonEvents.LISTENER_LEAVE.register(this, event -> {
            Listener patt2059$temp = event.getListener();
            if (!(patt2059$temp instanceof Runner)) {
                return;
            }
            Runner runner = (Runner)patt2059$temp;
            if (vault.get(Vault.STATS).get(runner).getCompletion() != Completion.COMPLETED) {
                return;
            }
            PlayerVaultStatsData data = PlayerVaultStatsData.get(world);
            runner.getPlayer().ifPresent(player -> data.updateFastestVaultTime((Player)player, vault.get(Vault.CLOCK).get(TickClock.LOGICAL_TIME)));
        });
        vault.get(Vault.LISTENERS).get(Listeners.LOGIC).set(ClassicListenersLogic.ADDED_BONUS_TIME);
    }

    @Override
    public void tickServer(VirtualWorld world, Vault vault) {
        PlayerVaultStatsData data = PlayerVaultStatsData.get(world);
        PlayerVaultStatsData.PlayerRecordEntry entry = data.getFastestVaultTime();
        if (!this.has(INITIALIZED)) {
            vault.get(Vault.CLOCK).set(TickClock.DISPLAY_TIME, entry.getTickCount());
            this.set(INITIALIZED);
        }
        vault.get(Vault.OBJECTIVES).forEach(KillBossObjective.class, objective -> {
            objective.set(KillBossObjective.BOSS_TYPE, ModEntities.ARENA_BOSS.getRegistryName());
            objective.set(KillBossObjective.BOSS_NAME, entry.getPlayerName());
            return false;
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean render(Vault vault, PoseStack matrixStack, Window window, float partialTicks, Player player) {
        return false;
    }

    @Override
    public boolean isActive(Vault vault, Objective objective) {
        return objective == this;
    }
}

