/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective.elixir;

import iskallia.vault.block.VaultOreBlock;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.ElixirObjective;
import iskallia.vault.core.vault.objective.elixir.ElixirTask;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.eventbus.api.EventPriority;

public class OreElixirTask
extends ElixirTask {
    public static final SupplierKey<ElixirTask> KEY = (SupplierKey)SupplierKey.of("ore", ElixirTask.class).with(Version.v1_12, (ElixirTask)((Object)((Supplier<ElixirTask>)OreElixirTask::new)));

    protected OreElixirTask() {
    }

    public OreElixirTask(int elixir) {
        this.set(ELIXIR, elixir);
    }

    @Override
    public SupplierKey<ElixirTask> getKey() {
        return KEY;
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault, ElixirObjective objective, UUID listener) {
        if ((Integer)this.get(ELIXIR) == 0) {
            return;
        }
        CommonEvents.PLAYER_MINE.register((Object)this, EventPriority.LOW, data -> {
            if (data.getPlayer().f_19853_ != world) {
                return;
            }
            if (!data.getPlayer().m_142081_().equals(listener)) {
                return;
            }
            if (!(data.getState().m_60734_() instanceof VaultOreBlock)) {
                return;
            }
            if (!((Boolean)data.getState().m_61143_((Property)VaultOreBlock.GENERATED)).booleanValue()) {
                return;
            }
            this.summonOrbs(world, data.getPos(), (int)((Integer)this.get(ELIXIR)));
            objective.addProgress(listener, (Integer)this.get(ELIXIR));
        });
    }

    @Override
    public void releaseServer() {
        CommonEvents.PLAYER_MINE.release(this);
    }

    public static class Config
    extends ElixirTask.Config<OreElixirTask> {
        public Config(WeightedList<IntRoll> rolls) {
            super(rolls);
        }

        @Override
        protected OreElixirTask create() {
            return new OreElixirTask();
        }
    }
}

