/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective.scavenger;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.ScavengerObjective;
import iskallia.vault.core.vault.objective.scavenger.ScavengeTask;
import iskallia.vault.core.vault.objective.scavenger.ScavengerGoal;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.tile.PartialBlockState;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.data.tile.TilePredicate;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ChestScavengerTask
extends ScavengeTask {
    public final TilePredicate target;
    public final double probability;
    public final ResourceLocation icon;
    public final WeightedList<Entry> entries;

    public ChestScavengerTask(TilePredicate target, double probability, ResourceLocation icon, WeightedList<Entry> entries) {
        this.target = target;
        this.probability = probability;
        this.icon = icon;
        this.entries = entries;
    }

    @Override
    public Optional<ScavengerGoal> generateGoal(int count, RandomSource random) {
        return this.entries.getRandom(random).map(entry -> new ScavengerGoal((int)Math.ceil((double)count * entry.multiplier)).put(entry.item, this.icon, entry.color));
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault, ScavengerObjective objective) {
        CommonEvents.CHEST_LOOT_GENERATION.post().register(objective, data -> {
            if (data.getPlayer().f_19853_ != world) {
                return;
            }
            if (data.getRandom().nextDouble() >= this.probability) {
                return;
            }
            PartialTile tile = PartialTile.of(PartialBlockState.of(data.getState()), PartialCompoundNbt.of((BlockEntity)data.getTileEntity()));
            if (!this.target.test(tile)) {
                return;
            }
            this.entries.getRandom(data.getRandom()).ifPresent(entry -> {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                items.add(this.createStack(vault, entry.item));
                CommonEvents.ITEM_SCAVENGE_TASK.invoke(vault, (Level)world, data.getPos(), items);
                data.getLoot().addAll(items);
            });
        });
    }

    public static class Entry {
        public final ItemStack item;
        public final double multiplier;
        public final int color;

        public Entry(ItemStack item, double multiplier, int color) {
            this.item = item;
            this.multiplier = multiplier;
            this.color = color;
        }
    }
}

