/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.objective.scavenger;

import iskallia.vault.block.VaultOreBlock;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.ScavengerObjective;
import iskallia.vault.core.vault.objective.scavenger.ScavengeTask;
import iskallia.vault.core.vault.objective.scavenger.ScavengerGoal;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.eventbus.api.EventPriority;

public class OreScavengerTask
extends ScavengeTask {
    public final double probability;
    public final ResourceLocation icon;
    public final WeightedList<Entry> entries;

    public OreScavengerTask(double probability, ResourceLocation icon, WeightedList<Entry> entries) {
        this.probability = probability;
        this.icon = icon;
        this.entries = entries;
    }

    @Override
    public Optional<ScavengerGoal> generateGoal(int count, RandomSource random) {
        return this.entries.getRandom(random).map(entry -> new ScavengerGoal((int)Math.ceil((double)count * entry.multiplier)).put(entry.item, this.icon, entry.color));
    }

    @Override
    public void initServer(VirtualWorld world, Vault vault, ScavengerObjective objective) {
        CommonEvents.PLAYER_MINE.register((Object)objective, EventPriority.LOW, data -> {
            if (data.getPlayer().f_19853_ != world) {
                return;
            }
            if (!(data.getState().m_60734_() instanceof VaultOreBlock)) {
                return;
            }
            if (!((Boolean)data.getState().m_61143_((Property)VaultOreBlock.GENERATED)).booleanValue()) {
                return;
            }
            ChunkRandom random = ChunkRandom.any();
            BlockPos pos = data.getPos();
            random.setBlockSeed(vault.get(Vault.SEED), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 110307L);
            if (random.nextDouble() >= this.probability) {
                return;
            }
            this.entries.getRandom(world.m_5822_()).ifPresent(entry -> {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                items.add(this.createStack(vault, entry.item));
                CommonEvents.ITEM_SCAVENGE_TASK.invoke(vault, (Level)world, data.getPos(), items);
                items.forEach(item -> Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)item));
            });
        });
    }

    public static class Entry {
        public final ItemStack item;
        public final double multiplier;
        public final int color;

        public Entry(ItemStack item, double multiplier, int color) {
            this.item = item;
            this.multiplier = multiplier;
            this.color = color;
        }
    }
}

