/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import iskallia.vault.client.atlas.ITextureAtlas;
import iskallia.vault.config.VaultModifierOverlayConfig;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.Modifiers;
import iskallia.vault.core.vault.modifier.VaultModifierStack;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModTextureAtlases;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModifiersRenderer {
    public static final ResourceLocation RESOURCE = new ResourceLocation("the_vault", "textures/gui/vault_hud.png");
    private static final boolean TEST_MODIFIERS = false;
    private static final Modifiers TEST_VAULT_MODIFIERS = new Modifiers();
    private static final ModifierTextRenderMode MODIFIER_TEXT_RENDER_MODE = ModifierTextRenderMode.SHADOW;
    private static final int BG_COLOR = Color.BLACK.getRGB();
    private static final float BG_A = (float)(BG_COLOR >> 24 & 0xFF) / 255.0f;
    private static final float BG_R = (float)(BG_COLOR >> 16 & 0xFF) / 255.0f;
    private static final float BG_G = (float)(BG_COLOR >> 8 & 0xFF) / 255.0f;
    private static final float BG_B = (float)(BG_COLOR & 0xFF) / 255.0f;
    private static final BufferBuilder ICON_BUFFER = new BufferBuilder(256);
    private static final MultiBufferSource.BufferSource TEXT_BUFFER = MultiBufferSource.m_109898_((BufferBuilder)new BufferBuilder(256));
    private static final BufferBuilder BOX_BUFFER = new BufferBuilder(256);
    public static final Vector3f SHADOW_OFFSET = new Vector3f(0.0f, 0.0f, -1.0f);

    public static void render(Map<VaultModifier<?>, Integer> modifiers, PoseStack matrixStack) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)RESOURCE);
        RenderSystem.m_69465_();
        ModifiersRenderer.renderVaultModifiers(modifiers, matrixStack, false);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
    }

    public static void renderVaultModifiers(List<VaultModifierStack> group, PoseStack matrixStack) {
        Object2IntLinkedOpenHashMap modifiers = new Object2IntLinkedOpenHashMap();
        for (VaultModifierStack stack : group) {
            modifiers.put(stack.getModifier(), stack.getSize());
        }
        ModifiersRenderer.renderVaultModifiers(modifiers, matrixStack, false);
    }

    public static void renderVaultModifiersWithDepth(List<VaultModifierStack> group, PoseStack matrixStack) {
        Object2IntLinkedOpenHashMap modifiers = new Object2IntLinkedOpenHashMap();
        for (VaultModifierStack stack : group) {
            modifiers.put(stack.getModifier(), stack.getSize());
        }
        ModifiersRenderer.renderVaultModifiers(modifiers, matrixStack, true);
    }

    public static void renderVaultModifiers(Map<VaultModifier<?>, Integer> group, PoseStack matrixStack, boolean depthTest) {
        Minecraft minecraft = Minecraft.m_91087_();
        int right = minecraft.m_91268_().m_85445_();
        int bottom = minecraft.m_91268_().m_85446_();
        VaultModifierOverlayConfig config = ModConfigs.VAULT_MODIFIER_OVERLAY;
        int textOffsetX = 4;
        int textOffsetY = 2;
        ITextureAtlas textureAtlas = ModTextureAtlases.MODIFIERS.get();
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        if (!ICON_BUFFER.m_85732_()) {
            ICON_BUFFER.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        }
        if (MODIFIER_TEXT_RENDER_MODE == ModifierTextRenderMode.BOX && !BOX_BUFFER.m_85732_()) {
            BOX_BUFFER.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        }
        int index = 0;
        for (Map.Entry<VaultModifier<?>, Integer> entry : group.entrySet()) {
            VaultModifier<?> modifier = entry.getKey();
            int amount = entry.getValue();
            Optional<ResourceLocation> icon = modifier.getIcon();
            if (icon.isEmpty()) continue;
            TextureAtlasSprite sprite = textureAtlas.getSprite(icon.get());
            int iconOffsetX = (config.size + config.spacingX) * (index % config.columns);
            int iconOffsetY = (config.size + config.spacingY) * (index / config.columns);
            int iconX = right - (config.rightMargin + config.size) - iconOffsetX;
            int iconY = bottom - config.size - config.bottomMargin - iconOffsetY;
            ICON_BUFFER.m_85982_(matrix, (float)iconX, (float)iconY + (float)config.size, 0.0f).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_5752_();
            ICON_BUFFER.m_85982_(matrix, (float)iconX + (float)config.size, (float)iconY + (float)config.size, 0.0f).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_5752_();
            ICON_BUFFER.m_85982_(matrix, (float)iconX + (float)config.size, (float)iconY, 0.0f).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_5752_();
            ICON_BUFFER.m_85982_(matrix, (float)iconX, (float)iconY, 0.0f).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_5752_();
            if (amount > 1) {
                Matrix4f outlineMatrix;
                String textString = "x" + amount;
                int textWidth = minecraft.f_91062_.m_92895_(textString);
                if (MODIFIER_TEXT_RENDER_MODE != ModifierTextRenderMode.NONE) {
                    Font font = minecraft.f_91062_;
                    float f = iconX + config.size - textWidth + 4;
                    int n = iconY + config.size;
                    Objects.requireNonNull(minecraft.f_91062_);
                    font.m_92811_(textString, f, (float)(n - 9 + 2), Color.WHITE.getRGB(), false, matrix, (MultiBufferSource)TEXT_BUFFER, false, 0, 0xF000F0);
                }
                if (MODIFIER_TEXT_RENDER_MODE == ModifierTextRenderMode.OUTLINE) {
                    outlineMatrix = matrix.m_27658_();
                    outlineMatrix.m_27648_(SHADOW_OFFSET);
                    for (int x = -1; x <= 1; ++x) {
                        for (int y = -1; y <= 1; ++y) {
                            if (x == 0 && y == 0) continue;
                            Font font = minecraft.f_91062_;
                            float f = x + iconX + config.size - textWidth + 4;
                            int n = y + iconY + config.size;
                            Objects.requireNonNull(minecraft.f_91062_);
                            font.m_92811_(textString, f, (float)(n - 9 + 2), Color.BLACK.getRGB(), false, outlineMatrix, (MultiBufferSource)TEXT_BUFFER, false, 0, 0xF000F0);
                        }
                    }
                }
                if (MODIFIER_TEXT_RENDER_MODE == ModifierTextRenderMode.SHADOW) {
                    outlineMatrix = matrix.m_27658_();
                    outlineMatrix.m_27648_(SHADOW_OFFSET);
                    Font font = minecraft.f_91062_;
                    float f = 1 + iconX + config.size - textWidth + 4;
                    int n = 1 + iconY + config.size;
                    Objects.requireNonNull(minecraft.f_91062_);
                    font.m_92811_(textString, f, (float)(n - 9 + 2), Color.BLACK.getRGB(), false, outlineMatrix, (MultiBufferSource)TEXT_BUFFER, false, 0, 0xF000F0);
                }
                if (MODIFIER_TEXT_RENDER_MODE == ModifierTextRenderMode.BOX) {
                    float minX = iconX + config.size - textWidth - 1 + 4;
                    int n = iconY + config.size;
                    Objects.requireNonNull(minecraft.f_91062_);
                    float minY = n - 9 - 1 + 2;
                    float maxX = iconX + config.size + 4;
                    float maxY = iconY + config.size - 1 + 2;
                    BOX_BUFFER.m_85982_(matrix, minX, maxY, 0.0f).m_85950_(BG_R, BG_G, BG_B, BG_A).m_5752_();
                    BOX_BUFFER.m_85982_(matrix, maxX, maxY, 0.0f).m_85950_(BG_R, BG_G, BG_B, BG_A).m_5752_();
                    BOX_BUFFER.m_85982_(matrix, maxX, minY, 0.0f).m_85950_(BG_R, BG_G, BG_B, BG_A).m_5752_();
                    BOX_BUFFER.m_85982_(matrix, minX, minY, 0.0f).m_85950_(BG_R, BG_G, BG_B, BG_A).m_5752_();
                }
            }
            ++index;
        }
        RenderSystem.m_69493_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        if (!depthTest) {
            RenderSystem.m_69465_();
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)textureAtlas.getAtlasResourceLocation());
        ICON_BUFFER.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)ICON_BUFFER);
        if (MODIFIER_TEXT_RENDER_MODE == ModifierTextRenderMode.BOX) {
            RenderSystem.m_69472_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            BOX_BUFFER.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)BOX_BUFFER);
        }
        if (MODIFIER_TEXT_RENDER_MODE != ModifierTextRenderMode.NONE) {
            TEXT_BUFFER.m_109911_();
        }
    }

    private static /* synthetic */ void lambda$static$0(VaultModifier vaultModifier) {
        TEST_VAULT_MODIFIERS.addModifier(vaultModifier, (int)(Math.random() * 10.0 + 1.0), true, JavaRandom.ofNanoTime());
    }

    public static enum ModifierTextRenderMode {
        PLAIN,
        OUTLINE,
        SHADOW,
        BOX,
        NONE;

    }
}

