/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.player;

import iskallia.vault.core.data.DataObject;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.data.key.registry.ISupplierKey;
import iskallia.vault.core.vault.ClassicPortalLogic;
import iskallia.vault.core.vault.EntityState;
import iskallia.vault.core.vault.PortalLogic;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.world.storage.VirtualWorld;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class ListenersLogic
extends DataObject<ListenersLogic>
implements ISupplierKey<ListenersLogic> {
    public static final FieldRegistry FIELDS = new FieldRegistry();

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    public abstract void initServer(VirtualWorld var1, Vault var2);

    public abstract void tickServer(VirtualWorld var1, Vault var2, Map<UUID, Listener> var3);

    public abstract void releaseServer();

    public abstract boolean onJoin(VirtualWorld var1, Vault var2, Listener var3);

    public abstract boolean onLeave(VirtualWorld var1, Vault var2, Listener var3);

    protected void keepInVault(VirtualWorld world, Vault vault, Collection<Listener> listeners) {
        listeners.forEach(listener -> listener.getPlayer().ifPresent(player -> {
            if (player.f_19853_ == world) {
                return;
            }
            vault.ifPresent(Vault.WORLD, manager -> {
                PortalLogic patt1777$temp = manager.get(WorldManager.PORTAL_LOGIC);
                if (!(patt1777$temp instanceof ClassicPortalLogic)) {
                    return;
                }
                ClassicPortalLogic logic = (ClassicPortalLogic)patt1777$temp;
                logic.getPlayerStart((Level)world, vault).ifPresent(state -> {
                    this.teleportSafe((EntityState)state, manager.get(WorldManager.FACING), (ServerPlayer)player);
                    this.onTeleport(world, vault, (ServerPlayer)player);
                });
            });
        }));
    }

    private void teleportSafe(EntityState state, Direction directionHint, ServerPlayer player) {
        AABB box = player.f_19815_.m_20393_(Vec3.f_82478_);
        BlockPos startPos = state.getBlockPos();
        if (!state.isColliding(box)) {
            state.teleport((Entity)player);
            return;
        }
        int moveLimit = startPos.m_123304_(directionHint.m_122434_());
        for (BlockPos offset : BlockPos.m_121935_((BlockPos)startPos, (int)5, (Direction)directionHint, (Direction)directionHint.m_122427_())) {
            int moveOffset = offset.m_123304_(directionHint.m_122434_());
            int diff = (moveLimit - moveOffset) * directionHint.m_122436_().m_123304_(directionHint.m_122434_());
            if (diff > 0 || state.isColliding(box)) continue;
            state.teleport((Entity)player);
            return;
        }
        state.teleport((Entity)player);
    }

    protected void onTeleport(VirtualWorld world, Vault vault, ServerPlayer player) {
    }

    protected void recallToJoinState(Stream<Listener> listeners) {
        listeners.forEach(listener -> {
            EntityState state = listener.get(Listener.JOIN_STATE);
            ServerPlayer player = listener.getPlayer().orElse(null);
            if (state != null && player != null) {
                state.teleport((Entity)player);
                player.m_20091_();
            }
        });
    }
}

