/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.pylon;

import com.google.gson.JsonObject;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.pylon.PylonBuff;
import iskallia.vault.core.vault.pylon.TickingPylonBuff;
import iskallia.vault.util.calc.PlayerStat;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;

public class StatPylonBuff
extends TickingPylonBuff<Config> {
    public StatPylonBuff(Config config) {
        super(config);
    }

    @Override
    public boolean isDone() {
        return super.isDone() || this.tick >= ((Config)this.config).duration;
    }

    @Override
    public void initServer(MinecraftServer server) {
        CommonEvents.PLAYER_STAT.register(this.uuid, data -> {
            if (!this.playerUuid.equals(data.getEntity().m_142081_())) {
                return;
            }
            if (data.getStat() != ((Config)this.config).stat) {
                return;
            }
            data.setValue(data.getValue() + ((Config)this.config).addend);
        });
    }

    @Override
    public void releaseServer() {
        CommonEvents.PLAYER_STAT.release(this.uuid);
    }

    public static class Config
    extends PylonBuff.Config<StatPylonBuff> {
        private PlayerStat stat;
        private float addend;
        private int duration;

        @Override
        public int getDuration() {
            return this.duration;
        }

        @Override
        public StatPylonBuff build() {
            return new StatPylonBuff(this);
        }

        @Override
        public void write(JsonObject object) {
            object.addProperty("type", "stat");
            object.addProperty("stat", this.stat.name());
            object.addProperty("addend", (Number)Float.valueOf(this.addend));
            object.addProperty("duration", (Number)this.duration);
        }

        @Override
        public void read(JsonObject object) {
            this.stat = Enum.valueOf(PlayerStat.class, object.get("stat").getAsString());
            this.addend = object.get("addend").getAsInt();
            this.duration = object.get("duration").getAsInt();
        }

        @Override
        public void write(CompoundTag object) {
            object.m_128359_("type", "stat");
            object.m_128359_("stat", this.stat.name());
            object.m_128350_("addend", this.addend);
            object.m_128405_("duration", this.duration);
        }

        @Override
        public void read(CompoundTag object) {
            this.stat = Enum.valueOf(PlayerStat.class, object.m_128461_("stat"));
            this.addend = object.m_128457_("addend");
            this.duration = object.m_128451_("duration");
        }
    }
}

