/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.stat;

import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.stat.ChestStat;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.stat.StatsCollector;
import iskallia.vault.core.vault.stat.VaultChestType;
import iskallia.vault.core.vault.stat.VaultSnapshot;
import iskallia.vault.util.VaultRarity;
import iskallia.vault.world.data.PlayerStatsData;
import iskallia.vault.world.data.VaultSnapshots;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public class StatTotals
implements INBTSerializable<CompoundTag> {
    private int bailed;
    private int failed;
    private int completed;
    private int experience;
    private final Object2FloatMap<ResourceLocation> damageReceived = new Object2FloatOpenHashMap();
    private final Object2FloatMap<ResourceLocation> damageDealt = new Object2FloatOpenHashMap();
    private final Object2IntMap<ResourceLocation> entitiesKilled = new Object2IntOpenHashMap();
    private int treasureRoomsOpened;
    private final Object2IntMap<ResourceLocation> minedBlocks = new Object2IntOpenHashMap();
    private final Object2IntMap<VaultChestType> trappedChests = new Object2IntOpenHashMap();
    private final Object2IntMap<ChestKey> lootedChests = new Object2IntOpenHashMap();
    private int crystalsCrafted;
    private static final String KEY_KEYS = "keys";
    private static final String KEY_VALUES = "values";
    private static final String KEY_BAILED = "survived";
    private static final String KEY_FAILED = "failed";
    private static final String KEY_COMPLETED = "completed";
    private static final String KEY_EXPERIENCE = "experience";
    private static final String KEY_DAMAGE_RECEIVED = "damageReceived";
    private static final String KEY_DAMAGE_DEALT = "damageDealt";
    private static final String KEY_ENTITIES_KILLED = "entitiesKilled";
    private static final String KEY_TREASURE_ROOMS_OPENED = "treasureRoomsOpened";
    private static final String KEY_MINED_BLOCKS = "minedBlocks";
    private static final String KEY_TRAPPED_CHESTS = "trappedChests";
    private static final String KEY_LOOTED_CHESTS = "lootedChests";
    private static final String KEY_CRYSTALS_CRAFTED = "crystalsCrafted";

    public static StatTotals of(UUID playerUuid) {
        List<Vault> vaults = VaultSnapshots.getAll().stream().map(VaultSnapshot::getEnd).filter(Objects::nonNull).toList();
        StatTotals statTotals = new StatTotals();
        for (Vault vault : vaults) {
            StatCollector collector;
            StatsCollector statsCollector = vault.get(Vault.STATS);
            if (statsCollector == null || (collector = statsCollector.get(playerUuid)) == null) continue;
            switch (collector.getCompletion()) {
                case BAILED: {
                    ++statTotals.bailed;
                    break;
                }
                case FAILED: {
                    ++statTotals.failed;
                    break;
                }
                case COMPLETED: {
                    ++statTotals.completed;
                }
            }
            statTotals.experience += collector.getExperience(vault);
            for (Object2FloatMap.Entry entry : collector.getDamageReceived().object2FloatEntrySet()) {
                statTotals.damageReceived.computeFloat((Object)((ResourceLocation)entry.getKey()), (resourceLocation, value) -> Float.valueOf((value == null ? 0.0f : value.floatValue()) + entry.getFloatValue()));
            }
            for (Object2FloatMap.Entry entry : collector.getDamageDealt().object2FloatEntrySet()) {
                statTotals.damageDealt.computeFloat((Object)((ResourceLocation)entry.getKey()), (resourceLocation, value) -> Float.valueOf((value == null ? 0.0f : value.floatValue()) + entry.getFloatValue()));
            }
            for (Object2FloatMap.Entry entry : collector.getEntitiesKilled().object2IntEntrySet()) {
                statTotals.entitiesKilled.computeInt((Object)((ResourceLocation)entry.getKey()), (arg_0, arg_1) -> StatTotals.lambda$of$2((Object2IntMap.Entry)entry, arg_0, arg_1));
            }
            statTotals.treasureRoomsOpened += collector.getTreasureRoomsOpened();
            for (Object2FloatMap.Entry entry : collector.getMinedBlocks().object2IntEntrySet()) {
                statTotals.minedBlocks.computeInt((Object)((ResourceLocation)entry.getKey()), (arg_0, arg_1) -> StatTotals.lambda$of$3((Object2IntMap.Entry)entry, arg_0, arg_1));
            }
            ChestStat.List chestStats = collector.get(StatCollector.CHESTS);
            for (ChestStat stat : chestStats) {
                if (stat.has(ChestStat.TRAPPED)) {
                    statTotals.trappedChests.computeInt((Object)stat.get(ChestStat.TYPE), (resourceLocation, value) -> (value == null ? 0 : value) + 1);
                    continue;
                }
                statTotals.lootedChests.computeInt((Object)new ChestKey(stat.get(ChestStat.TYPE), stat.get(ChestStat.RARITY)), (resourceLocation, value) -> (value == null ? 0 : value) + 1);
            }
        }
        PlayerStatsData.Stats playerStatsData = PlayerStatsData.get().get(playerUuid);
        statTotals.crystalsCrafted = playerStatsData.getCrystals().size();
        return statTotals;
    }

    public int getBailed() {
        return this.bailed;
    }

    public int getFailed() {
        return this.failed;
    }

    public int getCompleted() {
        return this.completed;
    }

    public int getTotalVaults() {
        return this.getBailed() + this.getFailed() + this.getCompleted();
    }

    public int getExperience() {
        return this.experience;
    }

    public Map<ResourceLocation, Float> getDamageReceived() {
        return Collections.unmodifiableMap(this.damageReceived);
    }

    public Map<ResourceLocation, Float> getDamageDealt() {
        return Collections.unmodifiableMap(this.damageDealt);
    }

    public Map<ResourceLocation, Integer> getEntitiesKilled() {
        return Collections.unmodifiableMap(this.entitiesKilled);
    }

    public int getTreasureRoomsOpened() {
        return this.treasureRoomsOpened;
    }

    public Map<ResourceLocation, Integer> getMinedBlocks() {
        return Collections.unmodifiableMap(this.minedBlocks);
    }

    public Map<VaultChestType, Integer> getTrappedChests() {
        return Collections.unmodifiableMap(this.trappedChests);
    }

    public Map<ChestKey, Integer> getLootedChests() {
        return Collections.unmodifiableMap(this.lootedChests);
    }

    public int getCrystalsCrafted() {
        return this.crystalsCrafted;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(KEY_BAILED, this.bailed);
        tag.m_128405_(KEY_FAILED, this.failed);
        tag.m_128405_(KEY_COMPLETED, this.completed);
        tag.m_128405_(KEY_EXPERIENCE, this.experience);
        tag.m_128365_(KEY_DAMAGE_RECEIVED, (Tag)this.serializeResourceLocationMap(this.damageReceived));
        tag.m_128365_(KEY_DAMAGE_DEALT, (Tag)this.serializeResourceLocationMap(this.damageDealt));
        tag.m_128365_(KEY_ENTITIES_KILLED, (Tag)this.serializeResourceLocationMap(this.entitiesKilled));
        tag.m_128405_(KEY_TREASURE_ROOMS_OPENED, this.treasureRoomsOpened);
        tag.m_128365_(KEY_MINED_BLOCKS, (Tag)this.serializeResourceLocationMap(this.minedBlocks));
        tag.m_128365_(KEY_TRAPPED_CHESTS, (Tag)this.serializeEnumMap(this.trappedChests));
        tag.m_128365_(KEY_LOOTED_CHESTS, (Tag)this.serializeChestKeyMap(this.lootedChests));
        tag.m_128405_(KEY_CRYSTALS_CRAFTED, this.crystalsCrafted);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.bailed = tag.m_128451_(KEY_BAILED);
        this.failed = tag.m_128451_(KEY_FAILED);
        this.completed = tag.m_128451_(KEY_COMPLETED);
        this.experience = tag.m_128451_(KEY_EXPERIENCE);
        this.deserializeResourceLocationMap(tag.m_128469_(KEY_DAMAGE_RECEIVED), this.damageReceived);
        this.deserializeResourceLocationMap(tag.m_128469_(KEY_DAMAGE_DEALT), this.damageDealt);
        this.deserializeResourceLocationMap(tag.m_128469_(KEY_ENTITIES_KILLED), this.entitiesKilled);
        this.treasureRoomsOpened = tag.m_128451_(KEY_TREASURE_ROOMS_OPENED);
        this.deserializeResourceLocationMap(tag.m_128469_(KEY_MINED_BLOCKS), this.minedBlocks);
        this.deserializeEnumMap(tag.m_128469_(KEY_TRAPPED_CHESTS), ordinal -> VaultChestType.values()[ordinal], this.trappedChests);
        this.deserializeChestKeyMap(tag.m_128469_(KEY_LOOTED_CHESTS), this.lootedChests);
        this.crystalsCrafted = tag.m_128451_(KEY_CRYSTALS_CRAFTED);
    }

    private <T extends Enum<T>> CompoundTag serializeEnumMap(Object2IntMap<T> map) {
        return this.serializeMap((keys, values) -> {
            for (Object2IntMap.Entry entry : map.object2IntEntrySet()) {
                keys.add((Object)IntTag.m_128679_((int)((Enum)entry.getKey()).ordinal()));
                values.add((Object)IntTag.m_128679_((int)entry.getIntValue()));
            }
        });
    }

    private CompoundTag serializeChestKeyMap(Object2IntMap<ChestKey> map) {
        return this.serializeMap((keys, values) -> {
            for (Object2IntMap.Entry entry : map.object2IntEntrySet()) {
                keys.add((Object)((ChestKey)entry.getKey()).serializeNBT());
                values.add((Object)IntTag.m_128679_((int)entry.getIntValue()));
            }
        });
    }

    private CompoundTag serializeResourceLocationMap(Object2FloatMap<ResourceLocation> map) {
        return this.serializeMap((keys, values) -> {
            for (Object2FloatMap.Entry entry : map.object2FloatEntrySet()) {
                keys.add((Object)StringTag.m_129297_((String)((ResourceLocation)entry.getKey()).toString()));
                values.add((Object)FloatTag.m_128566_((float)entry.getFloatValue()));
            }
        });
    }

    private CompoundTag serializeResourceLocationMap(Object2IntMap<ResourceLocation> map) {
        return this.serializeMap((keys, values) -> {
            for (Object2IntMap.Entry entry : map.object2IntEntrySet()) {
                keys.add((Object)StringTag.m_129297_((String)((ResourceLocation)entry.getKey()).toString()));
                values.add((Object)IntTag.m_128679_((int)entry.getIntValue()));
            }
        });
    }

    private CompoundTag serializeMap(BiConsumer<ListTag, ListTag> consumer) {
        ListTag keyList = new ListTag();
        ListTag valueList = new ListTag();
        consumer.accept(keyList, valueList);
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128365_(KEY_KEYS, (Tag)keyList);
        compoundTag.m_128365_(KEY_VALUES, (Tag)valueList);
        return compoundTag;
    }

    private <T extends Enum<T>> void deserializeEnumMap(CompoundTag tag, Function<Integer, T> keyFunction, Object2IntMap<T> map) {
        this.deserializeMap(tag, (byte)3, (byte)3, (keys, values) -> {
            for (int i = 0; i < keys.size(); ++i) {
                map.put((Object)((Enum)keyFunction.apply(keys.m_128763_(i))), values.m_128763_(i));
            }
        });
    }

    private void deserializeChestKeyMap(CompoundTag tag, Object2IntMap<ChestKey> map) {
        this.deserializeMap(tag, (byte)2, (byte)3, (keys, values) -> {
            for (int i = 0; i < keys.size(); ++i) {
                map.put((Object)ChestKey.decode(keys.m_128757_(i)), values.m_128763_(i));
            }
        });
    }

    private void deserializeResourceLocationMap(CompoundTag tag, Object2FloatMap<ResourceLocation> map) {
        this.deserializeMap(tag, (byte)8, (byte)5, (keys, values) -> {
            for (int i = 0; i < keys.size(); ++i) {
                map.put((Object)ResourceLocation.m_135820_((String)keys.m_128778_(i)), values.m_128775_(i));
            }
        });
    }

    private void deserializeResourceLocationMap(CompoundTag tag, Object2IntMap<ResourceLocation> map) {
        this.deserializeMap(tag, (byte)8, (byte)3, (keys, values) -> {
            for (int i = 0; i < keys.size(); ++i) {
                map.put((Object)ResourceLocation.m_135820_((String)keys.m_128778_(i)), values.m_128763_(i));
            }
        });
    }

    private void deserializeMap(CompoundTag tag, byte keyType, byte valueType, BiConsumer<ListTag, ListTag> consumer) {
        ListTag keyList = tag.m_128437_(KEY_KEYS, (int)keyType);
        ListTag valueList = tag.m_128437_(KEY_VALUES, (int)valueType);
        if (keyList.size() != valueList.size()) {
            throw new IllegalStateException("Key / value size mismatch");
        }
        for (int i = 0; i < keyList.size(); ++i) {
            consumer.accept(keyList, valueList);
        }
    }

    private static /* synthetic */ Integer lambda$of$3(Object2IntMap.Entry entry, ResourceLocation resourceLocation, Integer value) {
        return (value == null ? 0 : value) + entry.getIntValue();
    }

    private static /* synthetic */ Integer lambda$of$2(Object2IntMap.Entry entry, ResourceLocation resourceLocation, Integer value) {
        return (value == null ? 0 : value) + entry.getIntValue();
    }

    public record ChestKey(VaultChestType type, VaultRarity rarity) {
        public ShortTag serializeNBT() {
            return ShortTag.m_129258_((short)((short)(this.type().ordinal() << 8 | this.rarity().ordinal() & 0xFF)));
        }

        public static ChestKey decode(short encoded) {
            return new ChestKey(VaultChestType.values()[encoded >> 8], VaultRarity.values()[encoded & 0xFF]);
        }
    }
}

