/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.vault.time.modifier;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.key.FieldKey;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.data.key.registry.FieldRegistry;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.core.vault.time.modifier.ClockModifier;
import iskallia.vault.init.ModEffects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;

public class VoidFluidExtension
extends ClockModifier {
    public static final SupplierKey<ClockModifier> KEY = (SupplierKey)SupplierKey.of("void_fluid", ClockModifier.class).with(Version.v1_0, (ClockModifier)((Object)((Supplier<ClockModifier>)VoidFluidExtension::new)));
    public static final FieldRegistry FIELDS = ClockModifier.FIELDS.merge(new FieldRegistry());
    public static final FieldKey<UUID> PLAYER = (FieldKey)FieldKey.of("player", UUID.class).with(Version.v1_0, Adapters.UUID, DISK.all()).register(FIELDS);

    protected VoidFluidExtension() {
    }

    public VoidFluidExtension(Player player) {
        this.set(PLAYER, player.m_142081_());
    }

    @Override
    public SupplierKey<ClockModifier> getKey() {
        return KEY;
    }

    @Override
    public FieldRegistry getFields() {
        return FIELDS;
    }

    @Override
    protected void apply(ServerLevel world, TickClock clock) {
        ServerPlayer player = world.m_142572_().m_6846_().m_11259_(this.get(PLAYER));
        if (player == null) {
            this.set(CONSUMED);
            return;
        }
        MobEffectInstance effect = player.m_21124_(ModEffects.TIMER_ACCELERATION);
        if (effect == null || effect.m_19564_() < 0) {
            this.set(CONSUMED);
            return;
        }
        int decrement = (effect.m_19564_() + 1) * 6;
        clock.set(TickClock.DISPLAY_TIME, clock.get(TickClock.DISPLAY_TIME) - decrement);
    }
}

