/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.data.entity;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.world.data.entity.OrEntityPredicate;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.entity.PartialEntity;
import iskallia.vault.core.world.data.entity.PartialEntityGroup;
import iskallia.vault.core.world.data.entity.PartialEntityTag;
import iskallia.vault.item.crystal.data.adapter.ISimpleAdapter;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

@FunctionalInterface
public interface EntityPredicate {
    public static final EntityPredicate FALSE = (pos, blockPos, nbt) -> false;
    public static final EntityPredicate TRUE = (pos, blockPos, nbt) -> true;

    public boolean test(Vec3 var1, BlockPos var2, PartialCompoundNbt var3);

    default public boolean test(PartialEntity entity) {
        return this.test(entity.getPos(), entity.getBlockPos(), entity.getNbt());
    }

    default public boolean test(Entity entity) {
        return this.test(entity.m_20182_(), entity.m_142538_(), PartialCompoundNbt.of(entity.serializeNBT()));
    }

    public static Optional<EntityPredicate> of(String string, boolean logErrors) {
        if (string.isEmpty()) {
            return Optional.of(TRUE);
        }
        return (switch (string.charAt(0)) {
            case '#' -> PartialEntityTag.parse(string, logErrors);
            case '@' -> PartialEntityGroup.parse(string, logErrors);
            default -> PartialEntity.parse(string, logErrors);
        }).map(o -> o);
    }

    public static class Adapter
    implements ISimpleAdapter<EntityPredicate, Tag, JsonElement> {
        private static ArrayAdapter<EntityPredicate> LIST = Adapters.ofArray(EntityPredicate[]::new, new Adapter());

        @Override
        public void writeBits(@Nullable EntityPredicate value, BitBuffer buffer) {
            buffer.writeBoolean(value == null);
            if (value != null) {
                if (value instanceof OrEntityPredicate) {
                    OrEntityPredicate or = (OrEntityPredicate)value;
                    buffer.writeBoolean(true);
                    LIST.writeBits((EntityPredicate)or.getChildren(), buffer);
                } else {
                    buffer.writeBoolean(false);
                    Adapters.UTF_8.writeBits(value.toString(), buffer);
                }
            }
        }

        @Override
        public final Optional<EntityPredicate> readBits(BitBuffer buffer) {
            if (buffer.readBoolean()) {
                return Optional.empty();
            }
            if (buffer.readBoolean()) {
                return LIST.readBits(buffer).map(OrEntityPredicate::new);
            }
            return Adapters.UTF_8.readBits(buffer).map(string -> EntityPredicate.of(string, true).orElse(FALSE));
        }

        @Override
        public Optional<Tag> writeNbt(@Nullable EntityPredicate value) {
            if (value == null) {
                return Optional.empty();
            }
            if (value instanceof OrEntityPredicate) {
                OrEntityPredicate or = (OrEntityPredicate)value;
                return LIST.writeNbt((EntityPredicate)or.getChildren());
            }
            return Optional.of(StringTag.m_129297_((String)value.toString()));
        }

        @Override
        public Optional<EntityPredicate> readNbt(@Nullable Tag nbt) {
            if (nbt == null) {
                return Optional.empty();
            }
            if (nbt instanceof ListTag) {
                ListTag list = (ListTag)nbt;
                return LIST.readNbt(list).map(OrEntityPredicate::new);
            }
            if (nbt instanceof StringTag) {
                StringTag string = (StringTag)nbt;
                return Optional.of(EntityPredicate.of(string.m_7916_(), true).orElse(FALSE));
            }
            return Optional.empty();
        }

        @Override
        public Optional<JsonElement> writeJson(@Nullable EntityPredicate value) {
            if (value == null) {
                return Optional.empty();
            }
            if (value instanceof OrEntityPredicate) {
                OrEntityPredicate or = (OrEntityPredicate)value;
                return LIST.writeJson((EntityPredicate)or.getChildren());
            }
            return Optional.of(new JsonPrimitive(value.toString()));
        }

        @Override
        public Optional<EntityPredicate> readJson(@Nullable JsonElement json) {
            JsonPrimitive primitive;
            if (json == null) {
                return Optional.empty();
            }
            if (json instanceof JsonArray) {
                JsonArray array = (JsonArray)json;
                return LIST.readJson(array).map(OrEntityPredicate::new);
            }
            if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
                return Optional.of(EntityPredicate.of(json.getAsString(), true).orElse(FALSE));
            }
            return Optional.empty();
        }
    }
}

