/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.data.entity;

import com.google.gson.JsonElement;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.world.data.entity.EntityPlacement;
import iskallia.vault.core.world.data.entity.PartialListNbt;
import iskallia.vault.core.world.data.item.ItemPlacement;
import iskallia.vault.core.world.data.item.PartialItem;
import iskallia.vault.core.world.data.tile.PartialBlockState;
import iskallia.vault.core.world.data.tile.TilePlacement;
import iskallia.vault.item.crystal.data.adapter.ISimpleAdapter;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class PartialCompoundNbt
implements TilePlacement<PartialCompoundNbt>,
EntityPlacement<PartialCompoundNbt>,
ItemPlacement<PartialCompoundNbt> {
    private CompoundTag nbt;

    protected PartialCompoundNbt(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public static PartialCompoundNbt empty() {
        return new PartialCompoundNbt(new CompoundTag());
    }

    public static PartialCompoundNbt of(CompoundTag nbt) {
        return new PartialCompoundNbt(nbt);
    }

    public static PartialCompoundNbt of(Entity entity) {
        if (entity == null) {
            return new PartialCompoundNbt(null);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("id", EntityType.m_20613_((EntityType)entity.m_6095_()).toString());
        return new PartialCompoundNbt(entity.m_20240_(nbt));
    }

    public static PartialCompoundNbt of(BlockEntity blockEntity) {
        if (blockEntity == null) {
            return new PartialCompoundNbt(null);
        }
        return new PartialCompoundNbt(blockEntity.m_187480_());
    }

    public static PartialCompoundNbt at(BlockGetter world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity == null) {
            return new PartialCompoundNbt(null);
        }
        return new PartialCompoundNbt(blockEntity.m_187480_());
    }

    public static PartialCompoundNbt of(ItemStack stack) {
        return new PartialCompoundNbt(stack.m_41783_());
    }

    @Override
    public boolean isSubsetOf(PartialCompoundNbt other) {
        if (this.nbt == null) {
            return true;
        }
        if (other.nbt == null || this.nbt.m_128440_() > other.nbt.m_128440_()) {
            return false;
        }
        for (String key : this.nbt.m_128431_()) {
            Tag nbt1 = this.nbt.m_128423_(key);
            Tag nbt2 = other.nbt.m_128423_(key);
            if (nbt1 == null) continue;
            if (nbt2 == null || nbt1.m_6458_() != nbt2.m_6458_()) {
                return false;
            }
            if (!(nbt1.m_7060_() == 10 ? !PartialCompoundNbt.of((CompoundTag)nbt1).isSubsetOf(PartialCompoundNbt.of((CompoundTag)nbt2)) : (nbt1 instanceof CollectionTag ? !PartialListNbt.of((CollectionTag)nbt1).isSubsetOf(PartialListNbt.of((CollectionTag)nbt2)) : !nbt1.equals(nbt2)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSubsetOf(LevelReader world, BlockPos pos) {
        if (this.nbt == null) {
            return true;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        return blockEntity != null && this.isSubsetOf(PartialCompoundNbt.of(blockEntity.m_187481_()));
    }

    @Override
    public boolean isSubsetOf(Entity entity) {
        return this.isSubsetOf(PartialCompoundNbt.of(entity));
    }

    @Override
    public boolean isSubsetOf(ItemStack stack) {
        return this.isSubsetOf(PartialCompoundNbt.of(stack));
    }

    @Override
    public void fillInto(PartialCompoundNbt other) {
        if (this.nbt == null) {
            return;
        }
        if (other.nbt == null) {
            other.nbt = new CompoundTag();
        }
        for (String key : this.nbt.m_128431_()) {
            Tag e = this.nbt.m_128423_(key);
            if (e == null) continue;
            if ((e = e.m_6426_()).m_7060_() == 10) {
                if (!other.nbt.m_128441_(key)) {
                    other.nbt.m_128365_(key, e);
                    continue;
                }
                PartialCompoundNbt.of((CompoundTag)e).fillInto(PartialCompoundNbt.of(other.nbt.m_128469_(key)));
                continue;
            }
            other.nbt.m_128365_(key, e);
        }
    }

    @Override
    public void place(CommonLevelAccessor world, BlockPos pos, int flags) {
        if (this.nbt == null) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity == null) {
            return;
        }
        blockEntity.m_142466_(this.nbt);
    }

    @Override
    public void place(CommonLevelAccessor world) {
    }

    @Override
    public Optional<ItemStack> generate(int count) {
        return Optional.empty();
    }

    @Override
    public boolean test(PartialBlockState state, PartialCompoundNbt nbt) {
        return this.isSubsetOf(nbt);
    }

    @Override
    public boolean test(Vec3 pos, BlockPos blockPos, PartialCompoundNbt nbt) {
        return this.isSubsetOf(nbt);
    }

    @Override
    public boolean test(PartialItem item, PartialCompoundNbt nbt) {
        return this.isSubsetOf(nbt);
    }

    public Optional<CompoundTag> asWhole() {
        return Optional.ofNullable(this.nbt);
    }

    @Override
    public PartialCompoundNbt copy() {
        return new PartialCompoundNbt(this.nbt == null ? null : this.nbt.m_6426_());
    }

    public String toString() {
        return this.nbt == null ? "" : this.nbt.toString();
    }

    public static Optional<PartialCompoundNbt> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialCompoundNbt.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialCompoundNbt parse(String string) throws CommandSyntaxException {
        return PartialCompoundNbt.parse(new StringReader(string));
    }

    public static PartialCompoundNbt parse(StringReader reader) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '{') {
            String string = reader.getString().substring(reader.getCursor());
            int index = string.lastIndexOf(125);
            if (index < 0) {
                throw new IllegalArgumentException("Unclosed nbt in tile '" + reader.getString() + "'");
            }
            return PartialCompoundNbt.of(new TagParser(new StringReader(string.substring(0, index + 1))).m_129373_());
        }
        return PartialCompoundNbt.of((CompoundTag)null);
    }

    public static class Adapter
    implements ISimpleAdapter<PartialCompoundNbt, Tag, JsonElement> {
        @Override
        public Optional<Tag> writeNbt(@Nullable PartialCompoundNbt value) {
            return value == null ? Optional.empty() : Adapters.COMPOUND_NBT.writeNbt(value.nbt);
        }

        @Override
        public Optional<PartialCompoundNbt> readNbt(@Nullable Tag nbt) {
            return nbt == null ? Optional.empty() : Adapters.COMPOUND_NBT.readNbt(nbt).map(PartialCompoundNbt::of);
        }
    }
}

