/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.data.entity;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.core.world.data.entity.EntityPlacement;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import java.util.Optional;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class PartialEntityTag
implements EntityPlacement<PartialEntityTag> {
    private ResourceLocation id;
    private PartialCompoundNbt nbt;

    public PartialEntityTag(ResourceLocation id, PartialCompoundNbt nbt) {
        this.id = id;
        this.nbt = nbt;
    }

    public static PartialEntityTag of(ResourceLocation id, PartialCompoundNbt entity) {
        return new PartialEntityTag(id, entity);
    }

    @Override
    public boolean isSubsetOf(PartialEntityTag other) {
        return (this.id == null || this.id.equals((Object)other.id)) && this.nbt.isSubsetOf(other.nbt);
    }

    @Override
    public boolean isSubsetOf(Entity entity) {
        return false;
    }

    @Override
    public void fillInto(PartialEntityTag other) {
        if (this.id != null) {
            other.id = this.id;
        }
        this.nbt.fillInto(other.nbt);
    }

    @Override
    public void place(CommonLevelAccessor world) {
    }

    @Override
    public boolean test(Vec3 pos, BlockPos blockPos, PartialCompoundNbt nbt) {
        if (!this.nbt.isSubsetOf(nbt)) {
            return false;
        }
        ResourceLocation id = this.nbt.asWhole().filter(tag -> tag.m_128425_("id", 8)).map(tag -> ResourceLocation.m_135820_((String)tag.m_128461_("id"))).orElse(null);
        if (id == null || !ForgeRegistries.ENTITIES.containsKey(id)) {
            return false;
        }
        EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(id);
        return type != null && type.getTags().anyMatch(tag -> tag.f_203868_().equals((Object)this.id));
    }

    @Override
    public PartialEntityTag copy() {
        return new PartialEntityTag(this.id, this.nbt.copy());
    }

    public String toString() {
        return (String)(this.id != null ? "#" + this.id : "") + this.nbt.toString();
    }

    public static Optional<PartialEntityTag> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialEntityTag.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialEntityTag parse(String string) throws CommandSyntaxException {
        return PartialEntityTag.parse(new StringReader(string));
    }

    public static PartialEntityTag parse(StringReader reader) throws CommandSyntaxException {
        if (reader.peek() != '#') {
            throw new IllegalArgumentException("Invalid entity tag '" + reader.getString() + "' does not start with #");
        }
        reader.skip();
        int cursor = reader.getCursor();
        while (reader.canRead() && PartialEntityTag.isCharValid(reader.peek())) {
            reader.skip();
        }
        String string = reader.getString().substring(cursor, reader.getCursor());
        try {
            return PartialEntityTag.of(new ResourceLocation(string), PartialCompoundNbt.parse(reader));
        }
        catch (ResourceLocationException e) {
            reader.setCursor(cursor);
            throw new IllegalArgumentException("Invalid tag identifier '" + string + "' in block tag '" + reader.getString() + "'");
        }
    }

    protected static boolean isCharValid(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c == '_' || c == ':' || c == '/' || c == '.' || c == '-';
    }
}

