/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.data.item;

import com.google.gson.JsonElement;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.item.ItemPlacement;
import iskallia.vault.item.crystal.data.adapter.ISimpleAdapter;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class PartialItem
implements ItemPlacement<PartialItem> {
    protected ResourceLocation id;

    protected PartialItem(ResourceLocation id) {
        this.id = id;
    }

    public static PartialItem empty() {
        return new PartialItem(null);
    }

    public static PartialItem of(ResourceLocation id) {
        return new PartialItem(id);
    }

    public static PartialItem of(Item item) {
        return new PartialItem(item.getRegistryName());
    }

    public static PartialItem of(ItemStack stack) {
        return new PartialItem(stack.m_41720_().getRegistryName());
    }

    @Override
    public boolean isSubsetOf(PartialItem other) {
        return this.id == null || this.id.equals((Object)other.id);
    }

    @Override
    public boolean isSubsetOf(ItemStack stack) {
        return this.isSubsetOf(PartialItem.of(stack));
    }

    @Override
    public void fillInto(PartialItem other) {
        if (this.id == null) {
            return;
        }
        other.id = this.id;
    }

    @Override
    public Optional<ItemStack> generate(int count) {
        return this.asWhole().map(item -> new ItemStack((ItemLike)item, count));
    }

    @Override
    public boolean test(PartialItem item, PartialCompoundNbt nbt) {
        return this.isSubsetOf(item);
    }

    public Optional<Item> asWhole() {
        if (!ForgeRegistries.ITEMS.containsKey(this.id)) {
            return Optional.empty();
        }
        return Optional.ofNullable((Item)ForgeRegistries.ITEMS.getValue(this.id));
    }

    @Override
    public PartialItem copy() {
        return new PartialItem(this.id);
    }

    public String toString() {
        return this.id == null ? "" : this.id.toString();
    }

    public static Optional<PartialItem> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialItem.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialItem parse(String string) throws CommandSyntaxException {
        return PartialItem.parse(new StringReader(string));
    }

    public static PartialItem parse(StringReader reader) throws CommandSyntaxException {
        if (!reader.canRead() || !PartialItem.isCharValid(reader.peek())) {
            return PartialItem.empty();
        }
        int cursor = reader.getCursor();
        while (reader.canRead() && PartialItem.isCharValid(reader.peek())) {
            reader.skip();
        }
        String string = reader.getString().substring(cursor, reader.getCursor());
        try {
            return PartialItem.of(new ResourceLocation(string));
        }
        catch (ResourceLocationException e) {
            reader.setCursor(cursor);
            throw new IllegalArgumentException("Invalid item identifier '" + string + "' in stack '" + reader.getString() + "'");
        }
    }

    protected static boolean isCharValid(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c == '_' || c == ':' || c == '/' || c == '.' || c == '-';
    }

    public static class Adapter
    implements ISimpleAdapter<PartialItem, Tag, JsonElement> {
        @Override
        public Optional<Tag> writeNbt(@Nullable PartialItem value) {
            return value == null ? Optional.empty() : Adapters.IDENTIFIER.writeNbt(value.id);
        }

        @Override
        public Optional<PartialItem> readNbt(@Nullable Tag nbt) {
            return nbt == null ? Optional.empty() : Adapters.IDENTIFIER.readNbt(nbt).map(PartialItem::of);
        }
    }
}

