/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.data.item;

import com.google.gson.JsonElement;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.item.ItemPlacement;
import iskallia.vault.core.world.data.item.PartialItem;
import iskallia.vault.item.crystal.data.adapter.ISimpleAdapter;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class PartialStack
implements ItemPlacement<PartialStack> {
    protected PartialItem item;
    protected PartialCompoundNbt nbt;

    protected PartialStack(PartialItem item, PartialCompoundNbt nbt) {
        this.item = item;
        this.nbt = nbt;
    }

    public static PartialStack of(PartialItem item, PartialCompoundNbt nbt) {
        return new PartialStack(item, nbt);
    }

    public static PartialStack of(ItemStack stack) {
        return new PartialStack(PartialItem.of(stack), PartialCompoundNbt.of(stack));
    }

    public PartialItem getItem() {
        return this.item;
    }

    public PartialCompoundNbt getNbt() {
        return this.nbt;
    }

    public void setItem(PartialItem item) {
        this.item = item;
    }

    public void setNbt(PartialCompoundNbt nbt) {
        this.nbt = nbt;
    }

    @Override
    public boolean isSubsetOf(PartialStack other) {
        if (!this.item.isSubsetOf(other.item)) {
            return false;
        }
        return this.nbt.isSubsetOf(other.nbt);
    }

    @Override
    public boolean isSubsetOf(ItemStack stack) {
        if (!this.item.isSubsetOf(stack)) {
            return false;
        }
        return this.nbt.isSubsetOf(stack);
    }

    @Override
    public void fillInto(PartialStack other) {
        this.item.fillInto(other.item);
        this.nbt.fillInto(other.nbt);
    }

    @Override
    public Optional<ItemStack> generate(int count) {
        return this.item.generate(count).map(stack -> {
            stack.m_41751_((CompoundTag)this.nbt.asWhole().orElse(null));
            return stack;
        });
    }

    @Override
    public boolean test(PartialItem item, PartialCompoundNbt nbt) {
        return this.isSubsetOf(PartialStack.of(item, nbt));
    }

    @Override
    public PartialStack copy() {
        return new PartialStack(this.item.copy(), this.nbt.copy());
    }

    public String toString() {
        return this.item.toString() + this.nbt.toString();
    }

    public static Optional<PartialStack> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialStack.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialStack parse(String string) throws CommandSyntaxException {
        return PartialStack.parse(new StringReader(string));
    }

    public static PartialStack parse(StringReader reader) throws CommandSyntaxException {
        return PartialStack.of(PartialItem.parse(reader), PartialCompoundNbt.parse(reader));
    }

    public static class Adapter
    implements ISimpleAdapter<PartialStack, Tag, JsonElement> {
        @Override
        public Optional<Tag> writeNbt(@Nullable PartialStack value) {
            if (value == null) {
                return Optional.empty();
            }
            CompoundTag nbt = new CompoundTag();
            Adapters.PARTIAL_ITEM.writeNbt(value.item).ifPresent(tag -> nbt.m_128365_("item", tag));
            Adapters.PARTIAL_BLOCK_ENTITY.writeNbt(value.nbt).ifPresent(tag -> nbt.m_128365_("nbt", tag));
            return Optional.of(nbt);
        }

        @Override
        public Optional<PartialStack> readNbt(@Nullable Tag nbt) {
            if (nbt instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)nbt;
                PartialItem item = Adapters.PARTIAL_ITEM.readNbt(compound.m_128423_("item")).orElseThrow();
                PartialCompoundNbt tag = Adapters.PARTIAL_BLOCK_ENTITY.readNbt(compound.m_128423_("nbt")).orElseGet(PartialCompoundNbt::empty);
                return Optional.of(PartialStack.of(item, tag));
            }
            return Optional.empty();
        }
    }
}

