/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.data.tile;

import com.google.gson.JsonElement;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.tile.PartialBlockState;
import iskallia.vault.core.world.data.tile.TilePlacement;
import iskallia.vault.item.crystal.data.adapter.ISimpleAdapter;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class PartialBlock
implements TilePlacement<PartialBlock> {
    protected ResourceLocation id;

    protected PartialBlock(ResourceLocation id) {
        this.id = id;
    }

    public static PartialBlock empty() {
        return new PartialBlock(null);
    }

    public static PartialBlock of(ResourceLocation id) {
        return new PartialBlock(id);
    }

    public static PartialBlock of(Block block) {
        return new PartialBlock(block.getRegistryName());
    }

    public static PartialBlock of(BlockState state) {
        return new PartialBlock(state.m_60734_().getRegistryName());
    }

    @Override
    public boolean isSubsetOf(PartialBlock other) {
        return this.id == null || this.id.equals((Object)other.id);
    }

    @Override
    public boolean isSubsetOf(LevelReader world, BlockPos pos) {
        return this.isSubsetOf(PartialBlock.of(world.m_8055_(pos).m_60734_()));
    }

    @Override
    public void fillInto(PartialBlock other) {
        if (this.id == null) {
            return;
        }
        other.id = this.id;
    }

    @Override
    public void place(CommonLevelAccessor world, BlockPos pos, int flags) {
        this.asWhole().ifPresent(block -> {
            BlockState oldState = world.m_8055_(pos);
            BlockState newState = block.m_49966_();
            for (Property property : oldState.m_61147_()) {
                if (!newState.m_61138_(property)) continue;
                newState = (BlockState)newState.m_61124_(property, oldState.m_61143_(property));
            }
            world.m_7731_(pos, newState, flags);
        });
    }

    @Override
    public boolean test(PartialBlockState state, PartialCompoundNbt nbt) {
        return this.isSubsetOf(state.getBlock());
    }

    public Optional<Block> asWhole() {
        if (!ForgeRegistries.BLOCKS.containsKey(this.id)) {
            return Optional.empty();
        }
        return Optional.ofNullable((Block)ForgeRegistries.BLOCKS.getValue(this.id));
    }

    @Override
    public PartialBlock copy() {
        return new PartialBlock(this.id);
    }

    public String toString() {
        return this.id == null ? "" : this.id.toString();
    }

    public static Optional<PartialBlock> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialBlock.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialBlock parse(String string) throws CommandSyntaxException {
        return PartialBlock.parse(new StringReader(string));
    }

    public static PartialBlock parse(StringReader reader) throws CommandSyntaxException {
        if (!reader.canRead() || !PartialBlock.isCharValid(reader.peek())) {
            return PartialBlock.empty();
        }
        int cursor = reader.getCursor();
        while (reader.canRead() && PartialBlock.isCharValid(reader.peek())) {
            reader.skip();
        }
        String string = reader.getString().substring(cursor, reader.getCursor());
        try {
            return PartialBlock.of(new ResourceLocation(string));
        }
        catch (ResourceLocationException e) {
            reader.setCursor(cursor);
            throw new IllegalArgumentException("Invalid block identifier '" + string + "' in tile '" + reader.getString() + "'");
        }
    }

    protected static boolean isCharValid(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c == '_' || c == ':' || c == '/' || c == '.' || c == '-';
    }

    public static class Adapter
    implements ISimpleAdapter<PartialBlock, Tag, JsonElement> {
        @Override
        public Optional<Tag> writeNbt(@Nullable PartialBlock value) {
            return value == null ? Optional.empty() : Adapters.IDENTIFIER.writeNbt(value.id);
        }

        @Override
        public Optional<PartialBlock> readNbt(@Nullable Tag nbt) {
            return nbt == null ? Optional.empty() : Adapters.IDENTIFIER.readNbt(nbt).map(PartialBlock::of);
        }
    }
}

