/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.core.world.data.tile;

import com.google.gson.JsonElement;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.tile.PartialBlockState;
import iskallia.vault.core.world.data.tile.TilePlacement;
import iskallia.vault.item.crystal.data.adapter.ISimpleAdapter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class PartialBlockProperties
implements TilePlacement<PartialBlockProperties> {
    private final Map<String, String> properties;

    protected PartialBlockProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public static PartialBlockProperties empty() {
        return new PartialBlockProperties(new HashMap<String, String>());
    }

    public static PartialBlockProperties of(Map<String, String> properties) {
        return new PartialBlockProperties(properties);
    }

    public static PartialBlockProperties of(BlockState state) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Property property : state.m_61147_()) {
            properties.put(property.m_61708_(), property.m_6940_(state.m_61143_(property)));
        }
        return new PartialBlockProperties(properties);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public <T extends Comparable<T>> T get(Property<T> property) {
        return (T)((Comparable)property.m_6215_(this.properties.get(property.m_61708_())).orElse(null));
    }

    public <T extends Comparable<T>, V extends T> PartialBlockProperties set(Property<T> property, V value) {
        this.properties.put(property.m_61708_(), property.m_6940_(value));
        return this;
    }

    @Override
    public boolean isSubsetOf(PartialBlockProperties other) {
        if (other == null) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (entry.getValue().equals(other.properties.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSubsetOf(LevelReader world, BlockPos pos) {
        return this.isSubsetOf(PartialBlockProperties.of(world.m_8055_(pos)));
    }

    @Override
    public void fillInto(PartialBlockProperties other) {
        other.properties.putAll(this.properties);
    }

    @Override
    public void place(CommonLevelAccessor world, BlockPos pos, int flags) {
        BlockState newState;
        BlockState oldState = world.m_8055_(pos);
        if (oldState != (newState = this.apply(oldState))) {
            world.m_7731_(pos, newState, flags);
        }
    }

    @Override
    public boolean test(PartialBlockState state, PartialCompoundNbt nbt) {
        return this.isSubsetOf(state.getProperties());
    }

    public BlockState apply(BlockState state) {
        StateDefinition definition = state.m_60734_().m_49965_();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            Optional value;
            Property property = definition.m_61081_(entry.getKey());
            if (property == null || !state.m_61138_(property) || (value = property.m_6215_(entry.getValue())).isEmpty()) continue;
            state = (BlockState)state.m_61124_(property, (Comparable)value.get());
        }
        return state;
    }

    @Override
    public PartialBlockProperties copy() {
        return new PartialBlockProperties(new HashMap<String, String>(this.properties));
    }

    public String toString() {
        if (this.properties.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        Iterator<Map.Entry<String, String>> iterator = this.properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            sb.append(entry.getKey()).append('=').append(entry.getValue());
            if (!iterator.hasNext()) continue;
            sb.append(',');
        }
        return sb.append(']').toString();
    }

    public static Optional<PartialBlockProperties> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialBlockProperties.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialBlockProperties parse(String string) throws CommandSyntaxException {
        return PartialBlockProperties.parse(new StringReader(string));
    }

    public static PartialBlockProperties parse(StringReader reader) throws CommandSyntaxException {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (!reader.canRead() || reader.peek() != '[') {
            return PartialBlockProperties.of(properties);
        }
        reader.skip();
        int cursor = -1;
        reader.skipWhitespace();
        while (reader.canRead() && reader.peek() != ']') {
            reader.skipWhitespace();
            String key = reader.readString();
            int prevCursor = reader.getCursor();
            reader.skipWhitespace();
            if (properties.containsKey(key)) {
                reader.setCursor(cursor);
                throw new IllegalArgumentException("Duplicate property <" + key + "> in tile '" + reader.getString() + "'");
            }
            if (!reader.canRead() || reader.peek() != '=') {
                reader.setCursor(prevCursor);
                throw new IllegalArgumentException("Empty property <" + key + "> in tile '" + reader.getString() + "'");
            }
            reader.skip();
            reader.skipWhitespace();
            cursor = reader.getCursor();
            String value = reader.readString();
            properties.put(key, value);
            reader.skipWhitespace();
            if (!reader.canRead()) continue;
            cursor = -1;
            if (reader.peek() == ',') {
                reader.skip();
                continue;
            }
            if (reader.peek() == ']') break;
            throw new IllegalArgumentException("Unclosed properties in tile '" + reader.getString() + "'");
        }
        if (reader.canRead()) {
            reader.skip();
            return PartialBlockProperties.of(properties);
        }
        if (cursor >= 0) {
            reader.setCursor(cursor);
        }
        throw new IllegalArgumentException("Unclosed properties in tile '" + reader.getString() + "'");
    }

    public static class Adapter
    implements ISimpleAdapter<PartialBlockProperties, Tag, JsonElement> {
        @Override
        public Optional<Tag> writeNbt(@Nullable PartialBlockProperties value) {
            if (value == null || value.properties.isEmpty()) {
                return Optional.empty();
            }
            CompoundTag nbt = new CompoundTag();
            value.properties.forEach((arg_0, arg_1) -> ((CompoundTag)nbt).m_128359_(arg_0, arg_1));
            return Optional.of(nbt);
        }

        @Override
        public Optional<PartialBlockProperties> readNbt(@Nullable Tag nbt) {
            if (nbt instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)nbt;
                HashMap<String, String> properties = new HashMap<String, String>();
                for (String key : compound.m_128431_()) {
                    Tag tag = compound.m_128423_(key);
                    if (!(tag instanceof StringTag)) continue;
                    StringTag string = (StringTag)tag;
                    properties.put(key, string.m_7916_());
                }
                return Optional.of(PartialBlockProperties.of(properties));
            }
            if (nbt instanceof StringTag) {
                StringTag string = (StringTag)nbt;
                return PartialBlockProperties.parse(string.m_7916_(), true);
            }
            return Optional.empty();
        }
    }
}

